% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_image.R
\name{geom_image}
\alias{geom_image}
\title{geom_image}
\usage{
geom_image(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", inherit.aes = TRUE, na.rm = FALSE,
  by = "width", nudge_x = 0, angle = 0, ...)
}
\arguments{
\item{mapping}{aes mapping}

\item{data}{data}

\item{stat}{stat}

\item{position}{position}

\item{inherit.aes}{logical, whether inherit aes from ggplot()}

\item{na.rm}{logical, whether remove NA values}

\item{by}{one of 'width' or 'height'}

\item{nudge_x}{horizontal adjustment to nudge image}

\item{angle}{angle of image}

\item{...}{additional parameters}
}
\value{
geom layer
}
\description{
geom layer for visualizing image files
}
\examples{
library("ggplot2")
library("ggimage")
set.seed(2017-02-21)
d <- data.frame(x = rnorm(10),
                y = rnorm(10),
                image = sample(c("https://www.r-project.org/logo/Rlogo.png",
                                "https://jeroenooms.github.io/images/frink.png"),
                              size=10, replace = TRUE)
               )
ggplot(d, aes(x, y)) + geom_image(aes(image=image))
}
\author{
guangchuang yu
}
