% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggheatmap.R
\name{ggheatmap}
\alias{ggheatmap}
\title{ggplot2 Version of Heatmap}
\arguments{
\item{data}{input data(matrix or data.frame)}

\item{color}{the color of heatmap}

\item{legendName}{character,the title of heatmap legend}

\item{scale}{character,the way of scale data("none", "row" or "column")}

\item{border}{character, the colour of border}

\item{shape}{character, the shape of cell("square", "circle" and "triangle").Default is NULL}

\item{cluster_rows}{whether rows should be clustered(TRUE of FALSE)}

\item{cluster_cols}{whether column should be clustered(TRUE of FALSE)}

\item{dist_method}{character,the method parameter of dist function. see \link{dist}}

\item{hclust_method}{character,the method parameter of hclust function, see \link{hclust}}

\item{text_show_rows}{a character you want to show for y-axis}

\item{text_show_cols}{a character you want to show for x-axis}

\item{text_position_rows}{character,the position of y-axis label("right" or "left")}

\item{text_position_cols}{character,the position of x-axis label("bottom" or "top")}

\item{annotation_cols}{a data.frame for column annotation}

\item{annotation_rows}{a data.frame for row annotation}

\item{annotation_color}{a list for annotation color}

\item{annotation_width}{a numeric for annotation width}

\item{annotation_position_rows}{character,the position of column annotation("right" or "left")}

\item{annotation_position_cols}{character,the position of row annotation("bottom" or "top")}

\item{show_cluster_cols}{whether show column cluster tree(TRUE of FALSE)}

\item{show_cluster_rows}{whether show row cluster tree(TRUE of FALSE)}

\item{cluster_num}{a numeric for cut cluster tree}

\item{tree_height_rows}{row cluster tree height}

\item{tree_height_cols}{column cluster tree height}

\item{tree_color_rows}{a character for row cluster tree color}

\item{tree_color_cols}{a character for column cluster tree color}

\item{tree_position_rows}{character,the position of row cluster tree("right" or "left")}

\item{tree_position_cols}{character,the position of column cluster tree("bottom" or "top")}

\item{levels_rows}{a character for  y-axis label levels}

\item{levels_cols}{a character for  x-axis label levels}
}
\value{
p
}
\description{
The flexibility and excellence of 'ggplot2' is unquestionable,
so many drawing tools basically need 'ggplot2' as the operating object.
In order to develop a heatmap drawing system based on ggplot2, we developed
this tool, mainly to solve the heatmap puzzle problem and the flexible
connection between the heatmap and the 'ggplot2' object.
The advantages of this tool are as follows:
1. More flexible label settings;
2. Realize the linkage of heatmap and 'ggplot2' drawing system,
which is helpful for operations such as puzzles;
3. Simple and easy to operate;
4. Optimization of clustering tree visualization.
}
\examples{
#Create data
library(ggheatmap)
library(tidyr)
library(aplot)
set.seed(123)
df <- matrix(runif(600,0,10),ncol = 12)
colnames(df) <- paste("sample",1:12,sep = "")
rownames(df) <- sapply(1:50, function(x)paste(sample(LETTERS,3,replace = FALSE),collapse = ""))
head(df)
#example 1
text_rows <- sample(rownames(df),3)
p <- ggheatmap(df,scale = "row",cluster_rows  = TRUE,cluster_cols = TRUE,
          text_show_rows = text_rows)\%>\%
          ggheatmap_theme(1,theme =list(
           theme(axis.text.x = element_text(angle = 90,face = "bold"),
           axis.text.y = element_text(colour = "red",face = "bold"))
  ))

#example 2
ggheatmap(df,cluster_rows = TRUE,cluster_cols = TRUE,
          border = "grey",
          shape = "circle",
          cluster_num = c(5,4),
          tree_color_rows = c("#3B4992FF","#EE0000FF","#008B45FF","#631879FF","#008280FF"),
          tree_color_cols = c("#0073C2FF", "#EFC000FF" ,"#868686FF", "#CD534CFF")
)


#sample 3
\donttest{
row_metaData <- data.frame(exprtype=sample(c("Up","Down"),50,replace = TRUE),
genetype=sample(c("Metabolism","Immune","None"),50,replace = TRUE))
rownames(row_metaData) <- rownames(df)
col_metaData <- data.frame(tissue=sample(c("Normal","Tumor"),12,replace = TRUE),
                           risklevel=sample(c("High","Low"),12,replace = TRUE))
rownames(col_metaData) <- colnames(df)
exprcol <- c("#EE0000FF","#008B45FF" )
names(exprcol) <- c("Up","Down")
genecol <- c("#EE7E30","#5D9AD3","#D0DFE6FF")
names(genecol) <- c("Metabolism","Immune","None")
tissuecol <- c("#98D352","#FF7F0E")
names(tissuecol) <- c("Normal","Tumor")
riskcol <- c("#EEA236FF","#46B8DAFF")
names(riskcol) <- c("High","Low")
col <- list(exprtype=exprcol,genetype=genecol,tissue=tissuecol,risklevel=riskcol)

p<- ggheatmap(df,cluster_rows = TRUE,cluster_cols = TRUE,scale = "row",
              cluster_num = c(5,3),
              tree_color_rows = c("#3B4992FF","#EE0000FF","#008B45FF","#631879FF","#008280FF"),
              tree_color_cols = c("#1F77B4FF","#FF7F0EFF","#2CA02CFF"),
              annotation_rows = row_metaData,
              annotation_cols = col_metaData,
              annotation_color = col
)
p
ggheatmap_theme(p,2:5,theme = list(
  theme(legend.text = element_text(face = "bold")),
  theme(legend.text = element_text(face = "bold")),
  theme(legend.text = element_text(face = "bold")),
  theme(legend.text = element_text(face = "bold"))

))



#sample 4
ggheatmap(df,cluster_rows = TRUE,cluster_cols = TRUE,scale = "row",
          cluster_num = c(5,3),
          tree_color_rows = c("#3B4992FF","#EE0000FF","#008B45FF","#631879FF","#008280FF"),
          tree_color_cols = c("#1F77B4FF","#FF7F0EFF","#2CA02CFF"),
          annotation_rows = row_metaData,
          annotation_cols = col_metaData,
          annotation_color = col,
          annotation_position_rows="right"
)

#sample 5
dat <- data.frame(marker=sample(c(1,NA),50,replace = TRUE),
gene=rownames(df),
shape=sample(c("T","F"),50,replace = TRUE))
p1 <- ggplot(dat,aes(x=1,y=gene,size=marker,color=shape,shape=shape))+
  geom_point()+theme_classic()+
  scale_color_manual(values = c("#D2691E","#1E87D2"))+
  theme(line = element_blank(),axis.text = element_blank(),axis.title = element_blank())+
  guides(size = FALSE)

p\%>\%insert_right(p1,width = 0.1)
}


}
\author{
Baiwei Luo
}
