% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position_disjoint_ranges.R
\name{position_disjoint_ranges}
\alias{position_disjoint_ranges}
\title{Segregrating overlapping ranges}
\usage{
position_disjoint_ranges(extend = 1, stepsize = 1)
}
\arguments{
\item{extend}{a \code{numeric} of length 1 indicating how far a range should
be extended in total for calculating overlaps. Setting this argument to a
positive number leaves some space between ranges in the same bin.}

\item{stepsize}{a \code{numeric} of length 1 that determines how much space
is added between bins in the y-direction. A positive value grows the bins
from bottom to top, while a negative value grows the bins from top to
bottom.}
}
\value{
A \emph{PositionDisjointRanges} object.
}
\description{
One-dimensional ranged data in the x-direction is segregated in
  the y-direction such that no overlap in twodimensional space occurs. This
  positioning works best when no relevant information is plotted in the
  y-direction.
}
\details{
An object is considered disjoint from a second object when the range
  between their \code{xmin} and \code{xmax} coordinates don't overlap.
  Objects that overlap are assigned to different bins in the y-direction,
  whereby lower bins are filled first. This way, information in the
  x-direction is preserved and different objects can be discerned.

  Note that this positioning is only particularly useful when y-coordinates
  do not encode relevant information. Geoms that pair well with this
  positioning are \code{\link[ggplot2:geom_tile]{geom_rect}} and
  \code{\link[ggplot2]{geom_tile}}.

  This positioning function was inspired by the \code{disjointBins()}
  function in the \code{IRanges} package, but has been written such that it
  accepts any numeric input next to solely integer input.
}
\examples{
# Even though geom_tile() is parametrised by middle-x values, it is
# internally converted to xmin, xmax, ymin, ymax parametrisation so the
# positioning still works.

ggplot() +
  geom_tile(aes(x = rnorm(200), y = 0),
            width = 0.2, height = 0.9,
            position = position_disjoint_ranges(extend = 0.1))
}
\seealso{
The \code{disjointBins} function the Bioconductor IRanges package.
}
