% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_gene_label.R
\name{geom_gene_label}
\alias{geom_gene_label}
\title{A 'ggplot2' geom to add text labels to gene arrows}
\usage{
geom_gene_label(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", na.rm = FALSE, show.legend = FALSE,
  inherit.aes = TRUE, padding.x = grid::unit(1, "mm"),
  padding.y = grid::unit(0.1, "lines"), align = "centre",
  min.size = 4, grow = F, reflow = F, height = grid::unit(3, "mm"),
  ...)
}
\arguments{
\item{mapping, data, stat, position, na.rm, show.legend, inherit.aes, ...}{Standard
geom arguments as for \code{ggplot2::geom_text()}.}

\item{padding.x, padding.y}{\code{grid::unit()} object, giving horizontal or vertical
padding around the text. Defaults to 1 mm and 0.1 lines respectively.}

\item{align}{Where inside the gene to place the text label. Default is
'centre'; other options are 'left' and 'right'.}

\item{min.size}{Minimum font size, in points. If provided, text that would
need to be shrunk below this size to fit inside the gene arrow will not be
drawn. Defaults to 4 pt.}

\item{grow}{If \code{TRUE}, text will be grown as well as shrunk to fill the
arrow.}

\item{reflow}{If \code{TRUE}, text will be reflowed (wrapped) to better fit the
arrow.}

\item{height}{\code{grid::unit()} object giving the maximum height of the text.
Defaults to 3 mm, which is the default height of gene arrows drawn with
\code{geom_gene_arrow()}.}
}
\description{
\code{geom_gene_label()} can be used to add a text label to genes drawn with
\code{geom_gene_arrow()}.
}
\details{
\code{geom_gene_label()} uses the 'ggfittext' package to fit text to genes. All
text drawing options available in \code{ggfittext::geom_fit_text()} (growing,
reflowing, etc.) are also available here. For full details on how these
options work, see the documentation for \code{ggfittext::geom_fit_text()}.

Standard 'ggplot2' aesthetics for text are supported (see Aesthetics).
}
\section{Aesthetics}{

\itemize{
\item xmin,xmax (start and end of the gene; required)
\item y (molecule; required)
\item colour
\item size
\item alpha
\item family
\item fontface
\item angle
}
}

\examples{

ggplot2::ggplot(example_genes, ggplot2::aes(xmin = start, xmax = end,
  y = molecule, fill = gene, label = gene)) +
  geom_gene_arrow() +
  geom_gene_label() +
  ggplot2::facet_wrap(~ molecule, ncol = 1, scales = "free") +
  theme_genes()
}
\seealso{
geom_gene_arrow
}
