% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blend.R, R/blend_custom.R, R/bloom.R,
%   R/blur.R, R/displace.R, R/dither.R, R/inner_glow.R, R/interpolate.R,
%   R/kernel.R, R/mask.R, R/motion_blur.R, R/ordered_dither.R, R/outer_glow.R,
%   R/rasterise_grob.R, R/shade.R, R/variable_blur.R
\name{blend_raster}
\alias{blend_raster}
\alias{blend_custom_raster}
\alias{bloom_raster}
\alias{blur_raster}
\alias{displace_raster}
\alias{dither_raster}
\alias{inner_glow_raster}
\alias{interpolate_raster}
\alias{convolve_grob}
\alias{mask_raster}
\alias{motion_blur_raster}
\alias{ordered_dither_raster}
\alias{outer_glow_raster}
\alias{raster_helpers}
\alias{shade_raster}
\alias{variably_blur_raster}
\title{Raster Helpers}
\usage{
blend_raster(x, bg_layer, blend_type = "Over", flip_order = FALSE, alpha = NA)

blend_custom_raster(x, bg_layer, a, b, c, d, flip_order = FALSE, alpha = NA)

bloom_raster(
  x,
  threshold_lower = 80,
  threshold_upper = 100,
  sigma = 5,
  strength = 1,
  keep_alpha = TRUE
)

blur_raster(x, sigma = 0.5, stack = FALSE)

displace_raster(x, x_map, y_map = x_map, x_scale = 1, y_scale = x_scale)

dither_raster(x, max_colours = 256, colourspace = "sRGB")

inner_glow_raster(x, colour = "black", sigma = 3, expand = 0)

interpolate_raster(x, bg_layer, src_percent, bg_percent)

convolve_grob(
  x,
  kernel,
  iterations = 1,
  scaling = NULL,
  bias = NULL,
  stack = FALSE
)

mask_raster(x, mask, invert = FALSE)

motion_blur_raster(x, sigma = 0.5, angle = 0)

ordered_dither_raster(x, map, colourspace = "sRGB", offset = NULL)

outer_glow_raster(x, colour = "black", sigma = 3, expand = 0)

shade_raster(
  x,
  height_map,
  azimuth = 30,
  elevation = 30,
  strength = 10,
  sigma = 0,
  blend_type = "overlay"
)

variably_blur_raster(
  x,
  x_sigma,
  y_sigma = x_sigma,
  angle = NULL,
  x_scale = 1,
  y_scale = x_scale,
  angle_range = 0
)
}
\value{
A nativeRaster object
}
\description{
Raster Helpers
}
\keyword{internal}
