% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggelement.R
\name{element_roundrect}
\alias{element_roundrect}
\title{round rectangle borders and backgrounds}
\usage{
element_roundrect(
  fill = NULL,
  colour = NULL,
  size = NULL,
  linetype = NULL,
  color = NULL,
  r = grid::unit(0.1, "snpc"),
  inherit.blank = FALSE
)
}
\arguments{
\item{fill}{Fill colour.}

\item{colour, color}{Line/border colour. Color is an alias for colour.}

\item{size}{text size in pts.}

\item{linetype}{Line type. An integer (0:8), a name (blank, solid,
dashed, dotted, dotdash, longdash, twodash), or a string with
an even number (up to eight) of hexadecimal digits which give the
lengths in consecutive positions in the string.}

\item{r}{the radius of the rounded corners, a \code{unit} object,
default is unit(0.1, 'snpc').}

\item{inherit.blank}{Should this element inherit the existence of an
\code{element_blank} among its parents? If \code{TRUE} the existence of
a blank element among its parents will cause this element to be blank as
well. If \code{FALSE} any blank parent element will be ignored when
calculating final element state.}
}
\description{
round rectangle borders and backgrounds
}
\examples{
library(ggplot2)
p <- ggplot(mpg, aes(displ, cty)) + geom_point()
p <- p + facet_grid(cols = vars(cyl))
p <- p + theme(strip.background=element_roundrect(fill="grey40", color=NA, r=0.15))
p
p2 <- ggplot(mtcars, aes(mpg, disp, color=factor(cyl), size=cyl)) + 
      geom_point()
p2 + theme(legend.background=element_roundrect(color="#808080", linetype=2))
}
