% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_fortify_ts.R
\name{fortify.tsmodel}
\alias{fortify.tsmodel}
\alias{fortify.ar}
\alias{fortify.Arima}
\alias{fortify.fracdiff}
\alias{fortify.nnetar}
\alias{fortify.HoltWinters}
\alias{fortify.fGARCH}
\title{Convert time series models (like AR, ARIMA) to \code{data.frame}}
\usage{
\method{fortify}{tsmodel}(
  model,
  data = NULL,
  predict = NULL,
  is.date = NULL,
  ts.connect = TRUE,
  ...
)
}
\arguments{
\item{model}{Time series model instance}

\item{data}{original dataset, needed for \code{stats::ar}, \code{stats::Arima}}

\item{predict}{Predicted \code{stats::ts}
If not provided, try to retrieve from current environment using variable name.}

\item{is.date}{Logical frag indicates whether the \code{stats::ts} is date or not.
If not provided, regard the input as date when the frequency is 4 or 12.}

\item{ts.connect}{Logical frag indicates whether connects original time-series and predicted values}

\item{...}{other arguments passed to methods}
}
\value{
data.frame
}
\description{
Convert time series models (like AR, ARIMA) to \code{data.frame}
}
\examples{
fortify(stats::ar(AirPassengers))
fortify(stats::arima(UKgas))
fortify(stats::arima(UKgas), data = UKgas, is.date = TRUE)
fortify(forecast::auto.arima(austres))
fortify(forecast::arfima(AirPassengers))
fortify(forecast::nnetar(UKgas))
fortify(stats::HoltWinters(USAccDeaths))

data(LPP2005REC, package = 'timeSeries')
x = timeSeries::as.timeSeries(LPP2005REC)
d.Garch = fGarch::garchFit(LPP40 ~ garch(1, 1), data = 100 * x, trace = FALSE)
fortify(d.Garch)
}
