% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_aux.R
\name{gf_annotate}
\alias{gf_annotate}
\title{Add an annotation layer to a graphic}
\usage{
gf_annotate(
  object,
  geom = "text",
  x = NULL,
  y = NULL,
  xmin = NULL,
  xmax = NULL,
  ymin = NULL,
  ymax = NULL,
  xend = NULL,
  yend = NULL,
  ...,
  na.rm = FALSE
)
}
\arguments{
\item{object}{a gg object}

\item{geom}{name of geom to use for annotation}

\item{x, y, xmin, ymin, xmax, ymax, xend, yend}{positioning aesthetics -
you must specify at least one of these.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}
}
\description{
This function adds geoms to a plot, but unlike a typical geom function,
the properties of the geoms are not mapped from variables of a data frame,
but are instead passed in as vectors. This is useful for adding small annotations
(such as text labels) or if you have your data in vectors, and for some
reason don't want to put them in a data frame.
}
\details{
Note that all position aesthetics are scaled (i.e. they will expand the
limits of the plot so they are visible), but all other aesthetics are
set. This means that layers created with this function will never
affect the legend.
}
\section{Unsupported geoms}{


Due to their special nature, reference line geoms \code{\link[ggplot2:geom_abline]{geom_abline()}},
\code{\link[ggplot2:geom_hline]{geom_hline()}}, and \code{\link[ggplot2:geom_vline]{geom_vline()}} can't be used with \code{annotate()}.
You can use these geoms directly for annotations.

}

\examples{
p <- gf_point(mpg ~wt, data = mtcars)
p |> gf_annotate("text", x = 4, y = 25, label = "Some text")
p |> gf_annotate("text", x = 2:5, y = 25, label = "Some text")
p |> gf_annotate("rect", xmin = 3, xmax = 4.2, ymin = 12, ymax = 21,
             alpha = .2)
p |> gf_annotate("segment", x = 2.5, xend = 4, y = 15, yend = 25,
             colour = "blue")
p |> gf_annotate("pointrange", x = 3.5, y = 20, ymin = 12, ymax = 28,
             colour = "red", size = 2.5, linewidth = 1.5)

p |> gf_annotate("text", x = 2:3, y = 20:21, label = c("my label", "label 2"))

p |> gf_annotate("text", x = 4, y = 25, label = "italic(R) ^ 2 == 0.75",
             parse = TRUE)
p |> gf_annotate("text", x = 4, y = 25,
             label = "paste(italic(R) ^ 2, \" = .75\")", parse = TRUE)

}
\seealso{
The \href{https://ggplot2-book.org/annotations#sec-custom-annotations}{custom annotations section} of the online ggplot2 book.
}
