% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_functions.R
\name{gf_ellipse}
\alias{gf_ellipse}
\title{Formula interface to stat_ellipse()}
\usage{
gf_ellipse(
  object = NULL,
  gformula = NULL,
  data = NULL,
  ...,
  alpha,
  color,
  group,
  type = "t",
  level = 0.95,
  segments = 51,
  xlab,
  ylab,
  title,
  subtitle,
  caption,
  geom = "path",
  stat = "ellipse",
  position = "identity",
  show.legend = NA,
  show.help = NULL,
  inherit = TRUE,
  environment = parent.frame()
)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain.  Most users can safely ignore this argument.
See details and examples.}

\item{gformula}{A formula with shape \code{y ~ x}.
Faceting can be achieved by including \code{|} in the formula.}

\item{data}{A data frame with the variables to be plotted.}

\item{...}{Additional arguments.  Typically these are
(a) ggplot2 aesthetics to be set with \code{attribute = value},
(b) ggplot2 aesthetics to be mapped with \code{attribute = ~ expression}, or
(c) attributes of the layer as a whole, which are set with \code{attribute = value}.}

\item{alpha}{Opacity (0 = invisible, 1 = opaque).}

\item{color}{A color or a formula used for mapping color.}

\item{group}{Used for grouping.}

\item{type}{The type of ellipse.
The default \code{"t"} assumes a multivariate t-distribution, and
\code{"norm"} assumes a multivariate normal distribution.
\code{"euclid"} draws a circle with the radius equal to \code{level},
representing the euclidean distance from the center.
This ellipse probably won't appear circular unless \code{coord_fixed()} is applied.}

\item{level}{The confidence level at which to draw an ellipse (default is 0.95),
or, if \code{type="euclid"}, the radius of the circle to be drawn.}

\item{segments}{The number of segments to be used in drawing the ellipse.}

\item{xlab}{Label for x-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{ylab}{Label for y-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{title}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{subtitle}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{caption}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{geom}{Geom for drawing ellipse.  Note: \code{"polygon"} allows fill; \code{"path"} does not;
on the other hand, \code{"path"} allows \code{alpha} to be applied to the border, while \code{"polygon"}
applies \code{alpha} only to the interior.}

\item{stat}{A character string naming the stat used to make the layer.}

\item{position}{Either a character string naming the position function used
for the layer or a position object returned from a call to a position function.}

\item{show.legend}{A logical indicating whether this layer should be included in
the legends.  \code{NA}, the default, includes layer in the legends if any
of the attributes of the layer are mapped.}

\item{show.help}{If \code{TRUE}, display some minimal help.}

\item{inherit}{A logical indicating whether default attributes are inherited.}

\item{environment}{An environment in which to look for variables not found in \code{data}.}
}
\description{
Formula interface to \code{\link[ggplot2:stat_ellipse]{ggplot2::stat_ellipse()}}.
}
\examples{
gf_ellipse()
gf_point(eruptions ~ waiting, data = faithful) \%>\%
  gf_ellipse(alpha = 0.5)

gf_point(eruptions ~ waiting, data = faithful, color = ~ (eruptions > 3)) \%>\%
  gf_ellipse(alpha = 0.5)

gf_point(eruptions ~ waiting, data = faithful, color = ~ (eruptions > 3)) \%>\%
  gf_ellipse(type = "norm", linetype = ~ "norm") \%>\%
  gf_ellipse(type = "t",    linetype = ~ "t")

gf_point(eruptions ~ waiting, data = faithful, color = ~ (eruptions > 3)) \%>\%
  gf_ellipse(type = "norm",   linetype = ~ "norm") \%>\%
  gf_ellipse(type = "euclid", linetype = ~ "euclid", level = 3) \%>\%
  gf_refine(coord_fixed())

# Use geom = "polygon" to enable fill
gf_point(eruptions ~ waiting, data = faithful, fill = ~ (eruptions > 3)) \%>\%
  gf_ellipse(geom = "polygon", alpha = 0.3, color = "black")

gf_point(eruptions ~ waiting, data = faithful, fill = ~ (eruptions > 3)) \%>\%
  gf_ellipse(geom = "polygon", alpha = 0.3) \%>\%
  gf_ellipse(alpha = 0.3, color = "black")

gf_ellipse(eruptions ~ waiting, data = faithful, show.legend = FALSE,
  alpha = 0.3, fill = ~ (eruptions > 3), geom = "polygon") \%>\%
  gf_ellipse(level = 0.68, geom = "polygon", alpha = 0.3) \%>\%
  gf_point(data = faithful, color = ~ (eruptions > 3), show.legend = FALSE)
}
\seealso{
\code{\link[ggplot2:stat_ellipse]{ggplot2::stat_ellipse()}}
}
