% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_functions.R
\name{gf_rug}
\alias{gf_rug}
\alias{gf_rugx}
\alias{gf_rugy}
\title{Formula interface to geom_rug()}
\usage{
gf_rug(object = NULL, gformula = NULL, data = NULL, sides = "bl", alpha,
  color, group, linetype, size, xlab, ylab, title, subtitle, caption,
  geom = "rug", stat = "identity", position = "identity",
  show.legend = NA, show.help = NULL, inherit = TRUE,
  environment = parent.frame(), ...)

gf_rugx(object = NULL, gformula = NULL, data = NULL, sides = "b", alpha,
  color, group, linetype, size, xlab, ylab, title, subtitle, caption,
  geom = "rug", stat = "identity", position = "identity",
  show.legend = NA, show.help = NULL, inherit = FALSE,
  environment = parent.frame(), ...)

gf_rugy(object = NULL, gformula = NULL, data = NULL, sides = "l", alpha,
  color, group, linetype, size, xlab, ylab, title, subtitle, caption,
  geom = "rug", stat = "identity", position = "identity",
  show.legend = NA, show.help = NULL, inherit = FALSE,
  environment = parent.frame(), ...)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain.  Most users can safely ignore this argument.
See details and examples.}

\item{gformula}{A formula with shape \code{y ~ x} (\code{gf_rug()}) or \code{~ x} (\code{gf_rugx()}) or
\code{~ y} (\code{gf_rugy()}).}

\item{data}{A data frame with the variables to be plotted.}

\item{sides}{A string that controls which sides of the plot the rugs appear on.
It can be set to a string containing any of \code{"trbl"}, for top, right,
bottom, and left.}

\item{alpha}{Opacity (0 = invisible, 1 = opaque).}

\item{color}{A color or a formula used for mapping color.}

\item{group}{Used for grouping.}

\item{linetype}{A linetype (numeric or "dashed", "dotted", etc.) or a formula used
for mapping linetype.}

\item{size}{A numeric size or a formula used for mapping size.}

\item{xlab}{Label for x-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{ylab}{Label for y-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{title}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{subtitle}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{caption}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{geom}{A character string naming the geom used to make the layer.}

\item{stat}{A character string naming the stat used to make the layer.}

\item{position}{Either a character string naming the position function used
for the layer or a position object returned from a call to a position function.}

\item{show.legend}{A logical indicating whether this layer should be included in
the legends.  \code{NA}, the default, includes layer in the legends if any
of the attributes of the layer are mapped.}

\item{show.help}{If \code{TRUE}, display some minimal help.}

\item{inherit}{A logical indicating whether default attributes are inherited.}

\item{environment}{An environment in which to look for variables not found in \code{data}.}

\item{...}{Additional arguments.  Typically these are
(a) ggplot2 aesthetics to be set with \code{attribute = value},
(b) ggplot2 aesthetics to be mapped with \code{attribute = ~expression}, or
(c) attributes of the layer as a whole, which are set with \code{attribute = value}.}
}
\value{
a gg object
}
\description{
\code{gf_rugx()} and \code{gf_rugy()} are versions that only add a rug to x- or y- axis.
By default, these functions do not inherit from the formula in the original layer
(because doing so would often result in rugs on both axes), so the formula is required.
}
\details{
Positional aesthetics are specified using the formula in \code{gformula}.
Setting and mapping of additional attributes can be done through the
use of additional arguments.
Attributes can be set can be set using arguments of the form \code{attribute = value} or
mapped using arguments of the form \code{attribute = ~ expression}.

In formulas of the form \code{A | B}, \code{B} will be used to form facets using
\code{\link[=facet_wrap]{facet_wrap()}} or \code{\link[=facet_grid]{facet_grid()}}.
This provides an alternative to
\code{\link[=gf_facet_wrap]{gf_facet_wrap()}} and
\code{\link[=gf_facet_grid]{gf_facet_grid()}} that is terser and may feel more familiar to users
of \pkg{lattice}.

Evaluation of the \pkg{ggplot2} code occurs in the environment of \code{gformula}.
This will typically do the right thing when formulas are created on the fly, but might not
be the right thing if formulas created in one environment are used to create plots
in another.
}
\section{Aesthetics}{


{\code{geom_rug} understands the following aesthetics (required aesthetics are in bold):

\itemize{
  \item \code{alpha}
  \item \code{colour}
  \item \code{group}
  \item \code{linetype}
  \item \code{size}
  \item \code{x}
  \item \code{y}
}
}

}

\examples{
gf_point(Sepal.Length ~ Sepal.Width, data = iris) \%>\%
gf_rug(Sepal.Length ~ Sepal.Width)

# There are several ways to control x- and y-rugs separately
gf_point(Sepal.Length ~ Sepal.Width, data = iris) \%>\%
gf_rugx( ~ Sepal.Width,  data = iris, color = "red") \%>\%
gf_rugy(Sepal.Length ~ ., data = iris, color = "green")

gf_point(Sepal.Length ~ Sepal.Width, data = iris) \%>\%
gf_rug(. ~ Sepal.Width,  data = iris, color = "red", inherit = FALSE) \%>\%
gf_rug(Sepal.Length ~ ., data = iris, color = "green", inherit = FALSE)

gf_point(Sepal.Length ~ Sepal.Width, data = iris) \%>\%
gf_rug(. ~ Sepal.Width,  data = iris, color = "red", sides = "b") \%>\%
gf_rug(Sepal.Length ~ ., data = iris, color = "green", sides = "l")

# jitter requires both an x and a y, but we can turn off one or the other with sides
gf_jitter(Sepal.Length ~ Sepal.Width, data = iris) \%>\%
gf_rug(color = "green", sides = "b", position = "jitter")

# rugs work with some 1-varialbe plots as well.
gf_histogram( ~ eruptions, data = faithful) \%>\%
gf_rug( ~ eruptions, data = faithful, color = "red")\%>\%
gf_rug( ~ eruptions, data = faithful, color = "navy", sides = "t")

# we can take advantage of inheritance to shorten the code
gf_histogram( ~ eruptions, data = faithful) \%>\%
gf_rug(color = "red") \%>\%
gf_rug(color = "navy", sides = "t")

# Need to turn off inheritance when using gf_dhistogram:
gf_dhistogram( ~ eruptions, data = faithful) \%>\%
gf_rug( ~ eruptions, data = faithful, color = "red", inherit = FALSE)

# using jitter with gf_histogram() requires manually setting the y value.
gf_dhistogram(~ Sepal.Width, data = iris) \%>\%
gf_rug(0 ~ Sepal.Width, data = iris, color = "green", sides = "b", position = "jitter")

# the choice of y value can affect how the plot
gf_dhistogram(~ Sepal.Width, data = iris) \%>\%
gf_rug(0.5 ~ Sepal.Width, data = iris, color = "green", sides = "b", position = "jitter")
gf_jitter(Sepal.Length ~ Sepal.Width, data = iris) \%>\%
gf_rug( Sepal.Length ~ . , data = iris, color = "green") \%>\%
gf_rug( . ~ Sepal.Width, data = iris, color = "red")
}
\seealso{
\code{\link[ggplot2:geom_rug]{ggplot2::geom_rug()}}
}
