% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_functions.R
\name{gf_raster}
\alias{gf_raster}
\title{Formula interface to geom_raster()}
\usage{
gf_raster(object = NULL, gformula = NULL, data = NULL, geom = type,
  verbose = FALSE, add = inherits(object, c("gg", "ggplot")), ...,
  position = NULL, show.help = NULL)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain.  Most users can safely ignore this argument.
See details and examples.}

\item{gformula}{A formula with shape \code{y ~ x}.
Faceting can be acheived by including \code{|} in the formula.}

\item{data}{A data frame with the variables to be plotted.}

\item{geom}{A way to specify ggplot geoms that are not aliased to gf functions.}

\item{verbose}{If \code{TRUE} print the ggplot2 command in the console.}

\item{add}{If \code{TRUE} then construct just the layer with no frame.  The result
can be added to an existing frame.}

\item{...}{Additional arguments.  Typically these are
(a) ggplot2 aesthetics to be set with \code{attribute = value},
(b) ggplot2 aesthetics to be mapped with \code{attribute = ~expression}, or
(c) attributes of the layer as a whole, which are set with \code{attribute = value}.
Available attributes include
\code{alpha}, \code{color}, \code{fill}, \code{group}, \code{linetype}, \code{size}, \code{hjust}, \code{vjust}, \code{interpolate}}

\item{position}{Position adjustment, either as a string, or the result of a call to a position adjustment function.}

\item{show.help}{If \code{TRUE}, display some minimal help.}
}
\value{
a gg object
}
\description{
\pkg{ggformula} functions provide a formula interface to \code{ggplot2} layer
functions.
For plots with just one layer, the formula interface
is more compact and is consistent with modeling and \pkg{mosaic} notation.
The functions generate a \code{ggplot} command string which can be displayed by
setting \code{verbose = TRUE} as an argument.
}
\details{
Positional aesthetics are typically specified using a formula (see the \code{gformula} argument).
Additional formula terms of the form \code{+ attribute::value} map \code{attribute}
to \code{value}.
Additional terms of the form \code{+ attribute:value} will map \code{attribute}
to \code{value} if \code{value} is the name of a variable in \code{data}, else
\code{attribute} will be set to the constant \code{value}. Alternatively (and preferably)
attributes can be set can be set using arguments of the form \code{attribute = value} or
mapped using arguments of the form \code{attribute = ~ expression}.
In formulas of the form \code{A | B}, \code{B} will be used to form facets using
\code{\link{facet_wrap}()} or \code{\link{facet_grid}()}.
This provides an alternative to
\code{\link{gf_facet_wrap}()} and
\code{\link{gf_facet_grid}()} that is terser and may feel more familiar to users
of \pkg{lattice}.

Evaluation of the \pkg{ggplot2} code occurs in the environment of \code{gformula}.
This will typically do the right thing when formulas are created on the fly, but might not
be the right thing if formulas created in one environment are used to create plots
in another.
}
\examples{
# Justification controls where the cells are anchored
D <- expand.grid(x = 0:5, y = 0:5)
D$z <- runif(nrow(D))
# centered squares
gf_raster(z ~ x + y, data = D)
gf_raster(y ~ x, fill = ~ z, data = D)
# zero padding
gf_raster(z ~ x + y, data = D, hjust = 0, vjust = 0)
}
\seealso{
\code{\link{geom_raster}()}
}
