% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id-labeller.R
\name{id_labeller}
\alias{id_labeller}
\title{A facet labeller for \code{id}}
\usage{
id_labeller(labels)
}
\arguments{
\item{labels}{Data frame of labels. Usually contains only one
element, but facetting over multiple factors entails multiple
label variables.}
}
\description{
This function returns a \link[ggplot2:labeller]{ggplot2::labeller} that displays the \code{id} on several lines to improve readability.
}
\examples{
library(behavr)
metadata <- data.frame(
     id = sprintf("2017-09-01 20:00:12|toy_experiment_a_very_long_name|\%02d", 1:20),
     condition = c("A", "B"))
dt <- toy_activity_data(metadata, duration = hours(2))
pl <- ggetho(dt, aes(y = asleep)) + stat_pop_etho()
## Without labelling
pl + facet_wrap( ~ id)

## With labeller
pl + facet_wrap( ~ id, labeller = id_labeller)

}
\seealso{
\link[ggplot2:labeller]{ggplot2::labeller}, to make your own labellers
}
