% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/allFunctions.R
\name{getPath}
\alias{getPath}
\title{Determine the path between two varieties}
\usage{
getPath(v1, v2, ig, geneal, silent = FALSE, isDirected = FALSE)
}
\arguments{
  \item{v1}{the label of the first variety/vertex of
  interest (in character string format)}

  \item{v2}{the label of the second variety/vertex of
  interest (in character string format)}

  \item{ig}{the graph representation of the data genealogy
  (in igraph format)}

  \item{geneal}{the full genealogy (in data frame format)}

  \item{silent}{whether or not to print output (defaults to
  false)}

  \item{isDirected}{whether or not the graph is directed
  (defaults to false)}
}
\description{
Determines the shortest path between the two inputted
vertices, and takes into account whether or not the graph
is directed. If there is a path, the list of vertices of
the path will be returned. If there is not a path, a list
of character(0) will be returned. Note: For a directed
graph, the direction matters. However, this function will
check both directions and return the path if it exists.
}
\examples{
data(sbGeneal)
ig = dfToIG(sbGeneal)
getPath("Brim","Bedford",ig,sbGeneal)
getPath("Tokyo","Volstate",ig,sbGeneal)
}

