% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R, R/themes.R
\name{plot}
\alias{plot}
\alias{plot.ggeffects}
\alias{theme_ggeffects}
\alias{ggeffects_palette}
\alias{show_palettes}
\title{Plot ggeffects-objects}
\usage{
\method{plot}{ggeffects}(
  x,
  show_ci = TRUE,
  ci_style = c("ribbon", "errorbar", "dash", "dot"),
  show_data = FALSE,
  show_residuals = FALSE,
  show_residuals_line = FALSE,
  data_labels = FALSE,
  limit_range = FALSE,
  collapse_group = FALSE,
  show_legend = TRUE,
  show_title = TRUE,
  show_x_title = TRUE,
  show_y_title = TRUE,
  case = NULL,
  colors = NULL,
  alpha = 0.15,
  dot_size = NULL,
  dot_alpha = 0.35,
  dot_shape = NULL,
  line_size = NULL,
  jitter = NULL,
  dodge = 0.25,
  use_theme = TRUE,
  log_y = FALSE,
  connect_lines = FALSE,
  facets,
  grid,
  one_plot = TRUE,
  n_rows = NULL,
  verbose = TRUE,
  ...
)

theme_ggeffects(base_size = 11, base_family = "")

ggeffects_palette(palette = "metro", n = NULL)

show_palettes()
}
\arguments{
\item{x}{An object of class \code{ggeffects}, as returned by the functions
from this package.}

\item{show_ci}{Logical, if \code{TRUE}, confidence bands (for continuous variables
at x-axis) resp. error bars (for factors at x-axis) are plotted.}

\item{ci_style}{Character vector, indicating the style of the confidence
bands. May be either \code{"ribbon"}, \code{"errorbar"}, \code{"dash"} or \code{"dot"}, to plot
a ribbon, error bars, or dashed or dotted lines as confidence bands.}

\item{show_data}{Logical, if \code{TRUE}, a layer with raw data from response
by predictor on the x-axis, plotted as point-geoms, is added to the plot.
Note that if the model has a transformed response variable, and the
predicted values are \emph{not} back-transformed (i.e. if \code{back_transform = FALSE}),
the raw data points are plotted on the transformed scale, i.e. same scale
as the predictions.}

\item{show_residuals}{Logical, if \code{TRUE}, a layer with partial residuals is
added to the plot. See vignette
\href{https://cran.r-project.org/package=effects}{Effect Displays with Partial Residuals}.
from \strong{effects} for more details on partial residual plots.}

\item{show_residuals_line}{Logical, if \code{TRUE}, a loess-fit line is added to the
partial residuals plot. Only applies if \code{residuals} is \code{TRUE}.}

\item{data_labels}{Logical, if \code{TRUE} and row names in data are available,
data points will be labelled by their related row name.}

\item{limit_range}{Logical, if \code{TRUE}, limits the range of the prediction
bands to the range of the data.}

\item{collapse_group}{For mixed effects models, name of the grouping variable
of random effects. If \code{collapse_group = TRUE}, data points "collapsed"
by the first random effect groups are added to the plot. Else, if
\code{collapse_group} is a name of a group factor, data is collapsed by
that specific random effect. See \code{\link[=collapse_by_group]{collapse_by_group()}} for further
details.}

\item{show_legend}{Logical, shows or hides the plot legend.}

\item{show_title}{Logical, shows or hides the plot title-}

\item{show_x_title}{Logical, shows or hides the plot title for the x-axis.}

\item{show_y_title}{Logical, shows or hides the plot title for the y-axis.}

\item{case}{Desired target case. Labels will automatically converted into the
specified character case. See \code{?sjlabelled::convert_case} for more details
on this argument.}

\item{colors}{Character vector with color values in hex-format, valid
color value names (see \code{demo("colors")}) or a name of a
ggeffects-color-palette (see \code{ggeffects_palette()}).

Following options are valid for \code{colors}:
\itemize{
\item If not specified, the color brewer palette \code{"Set1"} will be used.
\item If \code{"gs"}, a greyscale will be used.
\item If \code{"bw"}, the plot is black/white and uses different line types to
distinguish groups.
\item There are some pre-defined color-palettes in this package that can be used,
e.g. \code{colors = "metro"}. See \code{\link[=show_palettes]{show_palettes()}} to show all available palettes.
\item Else specify own color values or names as vector (e.g.
\code{colors = c("#f00000", "#00ff00")}).
}}

\item{alpha}{Alpha value for the confidence bands.}

\item{dot_size}{Numeric, size of the point geoms.}

\item{dot_alpha}{Alpha value for data points, when \code{show_data = TRUE}.}

\item{dot_shape}{Shape of data points, when \code{show_data = TRUE}.}

\item{line_size}{Numeric, size of the line geoms.}

\item{jitter}{Numeric, between 0 and 1. If not \code{NULL} and \code{show_data = TRUE},
adds a small amount of random variation to the location of data points dots,
to avoid overplotting. Hence the points don't reflect exact values in the
data. May also be a numeric vector of length two, to add different
horizontal and vertical jittering. For binary outcomes, raw data is not
jittered by default to avoid that data points exceed the axis limits.}

\item{dodge}{Value for offsetting or shifting error bars, to avoid overlapping.
Only applies, if a factor is plotted at the x-axis (in such cases, the
confidence bands are replaced by error bars automatically), or if
\code{ci_style = "errorbars"}.}

\item{use_theme}{Logical, if \code{TRUE}, a slightly tweaked version of ggplot's
minimal-theme, \code{theme_ggeffects()}, is applied to the plot. If \code{FALSE}, no
theme-modifications are applied.}

\item{log_y}{Logical, if \code{TRUE}, the y-axis scale is log-transformed.
This might be useful for binomial models with predicted probabilities on
the y-axis.}

\item{connect_lines}{Logical, if \code{TRUE} and plot has point-geoms with
error bars (this is usually the case when the x-axis is discrete), points
of same groups will be connected with a line.}

\item{facets, grid}{Logical, defaults to \code{TRUE} if \code{x} has a column named
\code{facet}, and defaults to \code{FALSE} if \code{x} has no such column. Set
\code{facets = TRUE} to wrap the plot into facets even for grouping variables
(see 'Examples'). \code{grid} is an alias for \code{facets}.}

\item{one_plot}{Logical, if \code{TRUE} and \code{x} has a \code{panel} column (i.e. when
four \code{terms} were used), a single, integrated plot is produced.}

\item{n_rows}{Number of rows to align plots. By default, all plots are aligned
in one row. For facets, or multiple panels, plots can also be aligned in
multiiple rows, to avoid that plots are too small.}

\item{verbose}{Logical, toggle warnings and messages.}

\item{...}{Further arguments passed down to \verb{ggplot::scale_y*()}, to
control the appearance of the y-axis.}

\item{base_size}{Base font size.}

\item{base_family}{Base font family.}

\item{palette}{Name of a pre-defined color-palette as string. See
\code{show_palettes()} to show all available palettes. Use \code{NULL} to return
a list with names and color-codes of all avaibale palettes.}

\item{n}{Number of color-codes from the palette that should be returned.}
}
\value{
A ggplot2-object.
}
\description{
\code{plot} is a generic plot-method for \code{ggeffects}-objects.
\code{ggeffects_palette()} returns \code{show_palettes()}
}
\details{
For proportional odds logistic regression (see \code{?MASS::polr})
or cumulative link models in general, plots are automatically facetted
by \code{response.level}, which indicates the grouping of predictions based on
the level of the model's response.
}
\note{
Load \code{library(ggplot2)} and use \code{theme_set(theme_ggeffects())} to set
the \strong{ggeffects}-theme as default plotting theme. You can then use further
plot-modifiers, e.g. from \strong{sjPlot}, like \code{legend_style()} or \code{font_size()}
without losing the theme-modifications.

There are pre-defined colour palettes in this package. Use \code{show_palettes()}
to show all available colour palettes as plot, or
\code{ggeffects_palette(palette = NULL)} to show the color codes.
}
\section{Partial Residuals}{

For \strong{generalized linear models} (glms), residualized scores are
computed as \code{inv.link(link(Y) + r)} where \code{Y} are the predicted
values on the response scale, and \code{r} are the \emph{working} residuals.
\cr\cr
For (generalized) linear \strong{mixed models}, the random effect are also
partialled out.
}

\examples{
\dontshow{if (requireNamespace("ggplot2") && requireNamespace("sjlabelled")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(sjlabelled)
data(efc)
efc$c172code <- as_label(efc$c172code)
fit <- lm(barthtot ~ c12hour + neg_c_7 + c161sex + c172code, data = efc)

dat <- predict_response(fit, terms = "c12hour")
plot(dat)

\donttest{
# facet by group, use pre-defined color palette
dat <- predict_response(fit, terms = c("c12hour", "c172code"))
plot(dat, facet = TRUE, colors = "hero")

# don't use facets, b/w figure, w/o confidence bands
dat <- predict_response(fit, terms = c("c12hour", "c172code"))
plot(dat, colors = "bw", show_ci = FALSE)

# factor at x axis, plot exact data points and error bars
dat <- predict_response(fit, terms = c("c172code", "c161sex"))
plot(dat)

# for three variables, automatic facetting
dat <- predict_response(fit, terms = c("c12hour", "c172code", "c161sex"))
plot(dat)
}

# show color codes of specific palette
ggeffects_palette("okabe-ito")

# show all color palettes
show_palettes()
\dontshow{\}) # examplesIf}
}
