% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdr_points.R
\docType{data}
\name{geom_hdr_points}
\alias{geom_hdr_points}
\alias{stat_hdr_points}
\alias{StatHdrPoints}
\title{Scatterplot colored by highest density regions of a 2D density estimate}
\usage{
stat_hdr_points(
  mapping = NULL,
  data = NULL,
  geom = "point",
  position = "identity",
  ...,
  method = "kde",
  probs = c(0.99, 0.95, 0.8, 0.5),
  bins = NULL,
  n = 100,
  xlim = NULL,
  ylim = NULL,
  nudgex = "none",
  nudgey = "none",
  smooth = FALSE,
  adjust = c(1, 1),
  h = NULL,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_hdr_points(
  mapping = NULL,
  data = NULL,
  stat = "hdr_points",
  position = "identity",
  ...,
  method = "kde",
  probs = c(0.99, 0.95, 0.8, 0.5),
  bins = NULL,
  n = 100,
  xlim = NULL,
  ylim = NULL,
  nudgex = "none",
  nudgey = "none",
  smooth = FALSE,
  adjust = c(1, 1),
  h = NULL,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{method}{Density estimator to use, accepts character vector: \code{"kde"},
\code{"histogram"}, \code{"freqpoly"}, or \code{"mvnorm"}.}

\item{probs}{Probabilities to compute highest density regions for.}

\item{bins}{Number of bins along each axis for histogram and frequency polygon estimators.
Either a vector of length 2 or a scalar value which is recycled for both dimensions.
Defaults to normal reference rule (Scott, pg 87).}

\item{n}{Number of grid points in each direction.}

\item{xlim, ylim}{Range to compute and draw regions. If \code{NULL}, defaults to
range of data.}

\item{nudgex}{Horizontal rule for choosing witness points for smoothed
histogram method, accepts character vector: \code{"left"}, \code{"none"}, \code{"right"}.}

\item{nudgey}{Vertical rule for choosing witness points for smoothed
histogram method, accepts character vector: \code{"down"}, \code{"none"}, \code{"up"}.}

\item{smooth}{If \code{TRUE}, HDRs computed by the \code{"histogram"} method are
smoothed.}

\item{adjust}{A multiplicative bandwidth adjustment to be used if 'h' is
'NULL'. This makes it possible to adjust the bandwidth while still
using the a bandwidth estimator. For example, \code{adjust = 1/2} means
use half of the default bandwidth.}

\item{h}{Bandwidth (vector of length two). If \code{NULL}, estimated
using \code{\link[MASS:bandwidth.nrd]{MASS::bandwidth.nrd()}}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}
}
\description{
Perform 2D density estimation, compute the resulting highest density regions (HDRs),
and plot the provided data as a scatterplot with points colored according to
their corresponding HDR
}
\section{Aesthetics}{
 geom_hdr_points understands the following aesthetics (required
aesthetics are in bold):
\itemize{
\item \strong{x}
\item \strong{y}
\item alpha
\item color
\item fill
\item group
\item linetype
\item size
\item subgroup
}
}

\section{Computed variables}{


\describe{ \item{probs}{The probability associated with the highest density region, specified
by \code{probs}.} }
}

\examples{

# basic simulated data with bivariate normal data and various methods
# (note: code is commented out in this file to save cran check time)
df <- data.frame(x = rnorm(500), y = rnorm(500))
p <- ggplot(df, aes(x, y)) + coord_equal()
p + geom_hdr_points()
p + geom_hdr_points(method = "mvnorm")
p + geom_hdr_points(method = "freqpoly")
# p + geom_hdr_points(method = "histogram")

# setting aes(fill = after_stat(probs)), color = "black", and
# shape = 21 helps alleviate overplotting:
p + geom_hdr_points(aes(fill = after_stat(probs)), color = "black", shape = 21, size = 2)

# also works well with geom_hdr_lines():
p + geom_hdr_lines(aes(color = after_stat(probs)), alpha = 1) +
 geom_hdr_points(aes(fill = after_stat(probs)), color = "black", shape = 21, size = 2)

}
\keyword{datasets}
