% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustment_sets.R
\name{Adjust for variables}
\alias{Adjust for variables}
\alias{control_for}
\alias{ggdag_adjust}
\title{Adjust for variables and activate any biasing paths that result}
\usage{
control_for(.tdy_dag, var, as_factor = TRUE, ...)

ggdag_adjust(.tdy_dag, var = NULL, ..., node_size = 16, text_size = 3.88,
  label_size = text_size, text_col = "white", label_col = text_col,
  node = TRUE, stylized = TRUE, text = TRUE, use_labels = NULL,
  collider_lines = TRUE)
}
\arguments{
\item{.tdy_dag}{input graph, an object of class \code{tidy_dagitty} or
\code{dagitty}}

\item{var}{a character vector, the variable(s) to adjust for.}

\item{as_factor}{logical. Should the \code{adjusted} column be a factor?}

\item{...}{additional arguments passed to \code{tidy_dagitty()}}

\item{node_size}{size of DAG node}

\item{text_size}{size of DAG text}

\item{label_size}{size of label text}

\item{text_col}{color of DAG text}

\item{label_col}{color of label text}

\item{node}{logical. Should nodes be included in the DAG?}

\item{stylized}{logical. Should DAG nodes be stylized? If so, use
\code{geom_dag_nodes} and if not use \code{geom_dag_point}}

\item{text}{logical. Should text be included in the DAG?}

\item{use_labels}{a string. Variable to use for
\code{geom_dag_repel_label()}. Default is \code{NULL}.}

\item{collider_lines}{logical. Should the plot show paths activated by
adjusting for a collider?}
}
\value{
a \code{tidy_dagitty} with a \code{adjusted} column for adjusted
variables, as well as any biasing paths that arise, or a \code{ggplot}
}
\description{
Adjust for variables and activate any biasing paths that result
}
\examples{
dag <- dagify(m ~ a + b, x ~ a, y ~ b)

control_for(dag, var = "m")
ggdag_adjust(dag, var = "m")

}
