% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_corset_elongated.R
\name{gg_corset_elongated}
\alias{gg_corset_elongated}
\title{CORSET PLOT ELONGATED}
\arguments{
\item{data}{The name of the data frame.}

\item{x_var}{The name of the x_axis variable.}

\item{x_vals}{The values of the two time points.}

\item{y_var}{The repeated measure variable name.}

\item{group}{The name of units measured at each time point such as 'ID'.}

\item{c_var}{The name of variable to visualize by line colour, such as percent change.}

\item{eyelets}{Optional (default is FALSE). If set to true, this will visualize one of two mean types by c_var, as defined by the 'e_type' argument.}

\item{e_type}{Optional eyelet type if the eyelets parameter is set to TRUE. One of "SE" or "SD". The default is standard error ("SE") means. Alternatively, standard deviations ("SD") with means can be specified, which include horizontal lines to denote +1 and -1 standard deviation. Note that the visualization of standard deviations works best in tandem with the faceted option.}

\item{faceted}{Optional (default is FALSE). If set to true, the c_var will be faceted, with all lines visible in soft grey as a background in each facet.}

\item{vio_fill}{Optional (defaults to a soft black). Use to change the fill colour of the half violins.}

\item{line_size}{Optional. Use to change the size (thickness) of the lines which visualize the c_var. Default is 0.25.}
}
\value{
ggplot2 graphical object
}
\description{
This function visualizes a corset plot in long format.
}
\examples{

long.df <- data.frame(id = c(1,1,2,2,3,3),
             time = c("pre","post","pre","post","pre","post"),
             days  = c(3,5,4,0,7,7),
             change = c(28.57,28.57,-57.14,-57.14,0,0),
             direction = c("increase","increase","decrease","decrease","no change","no change"))

gg_corset_elongated(data = long.df, x_var = "time",
                   x_vals = c("pre","post"), y_var = "days",
                   group = "id", c_var = "change")

## Create groupings based on direction of change to use for eyelets:

gg_corset_elongated(data = long.df, x_var = "time", x_vals = c("pre","post"),
                    y_var = "days", group = "id", c_var = "direction", eyelets = TRUE)

## Create faceted corset plots based on direction of change:

gg_corset_elongated(data = long.df, x_var = "time", x_vals = c("pre","post"),
                    y_var = "days", group = "id", c_var = "direction", faceted = TRUE)

## Create faceted corset plots with standard deviation eyelets:

gg_corset_elongated(data = long.df, x_var = "time", x_vals = c("pre","post"),
                    y_var = "days", group = "id", c_var = "direction",
                    e_type = "SD", faceted = TRUE)

}
