% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_axis_line.R
\name{annotate_axis_line}
\alias{annotate_axis_line}
\title{Replace a axis line with an annotated segment}
\usage{
annotate_axis_line(
  axis = "x",
  x_position = "bottom",
  y_position = "left",
  colour = NULL,
  linewidth = NULL,
  ...
)
}
\arguments{
\item{axis}{The axis. Either "x" or "y"}

\item{x_position}{The position of the "x" axis, if applicable. Either "bottom" or "top".}

\item{y_position}{The position of the "y" axis, if applicable. Either "left" or "right".}

\item{colour}{The colour of the annotated segment.}

\item{linewidth}{The linewidth of the annotated segment.}

\item{...}{Extra parameters passed to \code{ggplot2::annotate("segment", ...)}.}
}
\value{
A list of a annotate layer and theme elements.
}
\description{
Replace a axis line with an annotated segment, so that geom features are in front of it.
}
\examples{
library(dplyr)
library(ggplot2)
library(ggblanket)
library(palmerpenguins)

set_blanket()

penguins |>
  add_row(
    flipper_length_mm = 175,
    body_mass_g = 2500,
    species = "Adelie",
  ) |>
  gg_blanket(
    x = flipper_length_mm,
    y = body_mass_g,
    col = species,
  ) +
  annotate_axis_line() +
  geom_point(size = 2.5)

}
