% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_sf.R
\name{gg_sf}
\alias{gg_sf}
\title{Sf ggplot.}
\usage{
gg_sf(
  data = NULL,
  col = NULL,
  facet = NULL,
  facet2 = NULL,
  group = NULL,
  text = NULL,
  stat = "sf",
  position = "identity",
  pal = NULL,
  pal_na = "#7F7F7F",
  alpha = 0.9,
  ...,
  titles = NULL,
  title = NULL,
  subtitle = NULL,
  coord = ggplot2::coord_sf(),
  col_breaks = NULL,
  col_include = NULL,
  col_intervals = NULL,
  col_labels = NULL,
  col_legend_place = NULL,
  col_legend_ncol = NULL,
  col_legend_nrow = NULL,
  col_limits = NULL,
  col_title = NULL,
  facet_labels = NULL,
  facet_ncol = NULL,
  facet_nrow = NULL,
  caption = NULL,
  theme = NULL
)
}
\arguments{
\item{data}{A sf object.}

\item{col}{Unquoted col and fill aesthetic variable.}

\item{facet}{Unquoted facet aesthetic variable.}

\item{facet2}{Unquoted second facet variable for a facet grid of facet by facet2 variables.}

\item{group}{Unquoted group aesthetic variable.}

\item{text}{Unquoted text aesthetic variable, which can be used in combination with plotly::ggplotly(., tooltip = "text").}

\item{stat}{Statistical transformation. A character string (e.g. "identity").}

\item{position}{Position adjustment. Either a character string (e.g."identity"), or a function (e.g. ggplot2::position_identity()).}

\item{pal}{Colours to use. A character vector of hex codes (or names).}

\item{pal_na}{Colour to use for NA values. A character vector of a hex code (or name).}

\item{alpha}{Opacity. A number between 0 and 1.}

\item{...}{Other arguments passed to the relevant ggplot2::geom_* function.}

\item{titles}{A function to format the x, y and col titles, including in rlang lambda format. Defaults to snakecase::to_sentence_case.}

\item{title}{Title string.}

\item{subtitle}{Subtitle string.}

\item{coord}{Coordinate system.}

\item{col_breaks}{A function that takes the limits as input (e.g. scales::breaks_pretty()), or a vector of breaks.}

\item{col_include}{For a numeric or date variable, any values that the scale should include (e.g. 0).}

\item{col_intervals}{A function to cut or chop the numeric variable into intervals (e.g. ~ santoku::chop_mean_sd(.x, drop = FALSE)).}

\item{col_labels}{A function that takes the breaks as inputs (e.g. scales::label_comma()), or a vector of labels. Note this does not affect where col_intervals is not NULL.}

\item{col_legend_place}{The place for the legend. "b" for bottom, "r" for right, "t" for top, or "l" for left.}

\item{col_legend_ncol}{The number of columns for the legend elements.}

\item{col_legend_nrow}{The number of rows for the legend elements.}

\item{col_limits}{A vector to determine the limits of the axis.}

\item{col_title}{Axis title string. Defaults to converting to sentence case with spaces. Use "" for no title.}

\item{facet_labels}{A function that takes the breaks as inputs (e.g. scales::label_comma()), or a named vector of labels (e.g. c(value = "label", ...)).}

\item{facet_ncol}{The number of columns of facetted plots.}

\item{facet_nrow}{The number of rows of facetted plots.}

\item{caption}{Caption title string.}

\item{theme}{A ggplot2 theme.}
}
\value{
A ggplot object.
}
\description{
Create a sf plot with a wrapper around the ggplot2:: \%>\%  function.
}
\examples{
if (requireNamespace("sf", quietly = TRUE)) {
  library(ggplot2)
  nc <- sf::st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)

  gg_sf(nc, col = AREA, col_legend_place = "b")
}

}
