% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choropleth.R
\docType{data}
\name{geom_choropleth}
\alias{geom_choropleth}
\alias{stat_choropleth}
\alias{StatChoropleth}
\title{Associate regions with counts}
\usage{
geom_choropleth(
  mapping = ggplot2::aes(),
  data = NULL,
  stat = "choropleth",
  position = "identity",
  ...,
  feature_type = NA,
  inset = NA,
  map_base = "normal",
  map_inset = "auto",
  na.rm = TRUE,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_choropleth(
  mapping = NULL,
  data = NULL,
  geom = "sf",
  position = "identity",
  ...,
  feature_type = NA,
  na.rm = TRUE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping, data, stat, geom, position, na.rm, show.legend, inherit.aes, ...}{See \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}}.}

\item{feature_type}{Type of map feature. See \code{\link[cartographer:feature_types]{feature_types()}} for a list of
registered types. If \code{NA}, the type is guessed based on the values in
\code{feature_names}.}

\item{inset}{Inset configuration; see \code{\link[ggmapinset:configure_inset]{configure_inset()}}.
If \code{NA} (the default), this is inherited from the coord (see \code{\link[ggmapinset:coord_sf_inset]{coord_sf_inset()}}).}

\item{map_base}{Controls the layer with the base map. Possible values are
\code{"normal"} to create a layer as though the inset were not specified,
\code{"clip"} to create a layer with the inset viewport cut out, and
\code{"none"} to prevent the insertion of a layer for the base map.}

\item{map_inset}{Controls the layer with the inset map. Possible values are
\code{"auto"} to choose the behaviour based on whether \code{inset} is specified,
\code{"normal"} to create a layer with the viewport cut out and transformed, and
\code{"none"} to prevent the insertion of a layer for the viewport map.}
}
\value{
A ggplot layer.
}
\description{
Counts the number of occurrences of each location, then by default maps the
count to the fill aesthetic. If your data has only one row per location and
some other field that you'd like to map to aesthetics, use
\code{\link[ggplot2:ggsf]{geom_sf()}} or \code{\link[ggmapinset:geom_sf_inset]{geom_sf_inset()}}
with \code{stat = "automap"} instead.
}
\details{
Note that choropleths have a tendency to be misleading by emphasising
geographically larger areas.
}
\section{Aesthetics}{

The \code{location} aesthetic is required.
\code{geom_choropleth()} understands the same aesthetics as \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}}.
}

\section{Computed variables}{

\describe{
\item{count}{rows matching the region}
\item{geometry}{\code{sf} geometry column}
\item{...}{limits as computed by \code{\link[ggplot2:ggsf]{ggplot2::stat_sf()}}}
}
}

\examples{
library(ggplot2)

cartographer::nc_type_example_2 |>
  ggplot(aes(location = county)) +
  geom_choropleth() +
  geom_boundaries(feature_type = "sf.nc") +
  scale_fill_steps(low = "#e6f9ff", high = "#00394d") +
  coord_automap(feature_type = "sf.nc")
}
\keyword{datasets}
