% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asymmetrise.R
\name{organize_levels}
\alias{organize_levels}
\title{Decides on the levels of factors x and y}
\usage{
organize_levels(x, y, ...)
}
\arguments{
\item{x, y}{Two factor vectors}

\item{...}{passed to \code{sort}; see \code{?sort} for options}
}
\value{
vector of levels or \code{NULL} for no levels
}
\description{
Organizes the levels to use for the two inputs. This is useful
    for when one wants to merge two vectors that are factors. Ideally, they
    have the same levels, in which case those are returned. If they have
    overlapping levels, then the levels are merged and sorted (using
    \code{sort()}). Otherwise, the levels are dropped (returning \code{NULL})
}
\examples{
set.seed(0)
a <- factor(sample(LETTERS, 5), levels = LETTERS)
b <- factor(sample(LETTERS, 5), levels = LETTERS)

a

b

organize_levels(a, b)
}
