% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asymmetrise_stats.R
\name{prepare_data}
\alias{prepare_data}
\title{Prepares the input data into asymmetrise_stats}
\usage{
prepare_data(.data)
}
\arguments{
\item{.data}{input data of either a \code{tibble}, \code{data.frame}, or results from a
statistical test}
}
\value{
a \code{tibble} data table
}
\description{
Tries to make the data ready for use in the
    \code{asymmetrise_stats()} function using \code{broom::tidy()}
}
\section{Warning}{

    If you repeatedly get errors, try preparing the data before-hand using
    \code{broom::tidy(.data)}
}

\examples{
a <- rnorm(10, mean = 1, sd = 1)
b <- rnorm(10, mean = 1.5, sd = 1)
prepare_data(t.test(a, b))

}
