% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout-chain-stack-genomic.R
\name{stack_genomic}
\alias{stack_genomic}
\alias{stack_genomicv}
\alias{stack_genomich}
\title{Create a stack Layout for Genomic Data}
\usage{
stack_genomic(direction, data = NULL, ..., theme = NULL, sizes = NA)

stack_genomicv(data = NULL, ...)

stack_genomich(data = NULL, ...)
}
\arguments{
\item{direction}{A string indicating the direction of the stack layout,
either \code{"h"}(\code{horizontal}) or \code{"v"}(\code{vertical}).}

\item{data}{The input data, which can be:
\itemize{
\item A \code{character} string ("hg19" or "hg38") to load a predefined cytoband
reference.
\item A \code{data.frame} with at least three columns: \code{chromosome}, \code{start}, and
\code{end} positions.
\item A genomic object convertible via \code{fortify_data_frame()}.
}}

\item{...}{Additional arguments passed to specific methods or
\code{\link[=fortify_data_frame]{fortify_data_frame()}}.}

\item{theme}{A \code{\link[ggplot2:theme]{theme()}} object used to customize various
elements of the layout, including \code{guides}, \code{title}, \code{subtitle}, \code{caption},
\code{margins}, \code{panel.border}, and \code{background}. By default, the theme will
inherit from the parent \code{layout}. It also controls the panel spacing for all
plots in the layout.}

\item{sizes}{A numeric value or a \code{\link[grid:unit]{unit}} object. When used for
the \code{\link[=quad_layout]{quad_layout()}} annotation, it must be of length \code{1}. When used in the
\code{\link[=stack_layout]{stack_layout()}} with a nested \code{\link[=quad_layout]{quad_layout()}}, it should be of length
\code{3}, specifying the relative heights (for \code{direction = "h"}) or widths (for
\code{direction = "v"}) to be applied to the layout.}
}
\value{
A \code{stack_layout} object representing the genomic layout.
}
\description{
\code{stack_genomic()} constructs a stack layout specifically for genomic
data. It is a specialized variant of \code{stack_continuous()} that applies
default axis limits and coerces the first column of each plot's data to use
chromosome (\code{seqname}) identifiers-matching those in the layout data-as
factor levels.
}
