% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align-kmeans.R
\name{align_kmeans}
\alias{align_kmeans}
\title{Split observations by k-means clustering groups.}
\usage{
align_kmeans(..., data = NULL, active = NULL)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[stats:kmeans]{stats::kmeans}}
  \describe{
    \item{\code{iter.max}}{the maximum number of iterations allowed.}
    \item{\code{nstart}}{if \code{centers} is a number, how many random sets
    should be chosen?}
    \item{\code{algorithm}}{character: may be abbreviated.  Note that
    \code{"Lloyd"} and \code{"Forgy"} are alternative names for one
    algorithm.}
    \item{\code{trace}}{logical or integer number, currently only used in the
    default method (\code{"Hartigan-Wong"}): if positive (or true),
    tracing information on the progress of the algorithm is
    produced.  Higher values may produce more tracing information.}
  }}

\item{data}{A numeric matrix to be used by k-means. By default, it will
inherit from the layout matrix.}

\item{active}{A \code{\link[=active]{active()}} object that defines the context settings when
added to a layout.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Aligns and groups observations based on k-means clustering, enabling
observation splits by cluster groups.
}
\section{Discrete Axis Alignment}{

It is important to note that we consider rows as observations, meaning
\code{vec_size(data)}/\code{NROW(data)} must match the number of observations along the
axis used for alignment (x-axis for a vertical stack layout, y-axis for a
horizontal stack layout).
}

\examples{
ggheatmap(matrix(rnorm(81), nrow = 9)) +
    anno_top() +
    align_kmeans(3L)
}
