% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout-heatmap-oncoplot.R
\name{ggoncoplot}
\alias{ggoncoplot}
\alias{ggoncoplot.default}
\title{Create \code{OncoPrint} Visualizations from Genetic Alteration Data}
\usage{
ggoncoplot(
  data = NULL,
  mapping = aes(),
  ...,
  map_width = NULL,
  map_height = NULL,
  reorder_row = reorder_column,
  reorder_column = TRUE,
  width = NA,
  height = NA,
  filling = waiver(),
  theme = NULL,
  active = NULL
)

\method{ggoncoplot}{default}(
  data = NULL,
  mapping = aes(),
  ...,
  map_width = NULL,
  map_height = NULL,
  reorder_row = reorder_column,
  reorder_column = TRUE,
  width = NA,
  height = NA,
  filling = waiver(),
  theme = NULL,
  active = NULL
)
}
\arguments{
\item{data}{A character matrix which encodes the alterations, you can use
regex \verb{[;:,|]} to separate multiple alterations.}

\item{mapping}{Default list of aesthetic mappings to use for plot.
If not specified, must be supplied in each layer added to the plot.}

\item{...}{Additional arguments passed to \code{\link[=fortify_matrix]{fortify_matrix()}}.}

\item{map_width, map_height}{A named numeric value defines the width/height of
each alterations.}

\item{reorder_row, reorder_column}{A boolean value indicating whether to
reorder the rows/columns based on the frequency or characteristics of the
alterations.}

\item{width, height}{The relative width/height of the main plot, can be a
\code{\link[grid:unit]{unit}} object.}

\item{filling}{Same as \code{\link[=ggheatmap]{ggheatmap()}}, but only \code{"tile"} can be used.}

\item{theme}{A \code{\link[ggplot2:theme]{theme()}} used to render the \code{guides},
\code{title}, \code{subtitle}, \code{caption}, \code{margins}, \code{patch.title}, \code{panel.border}, and
\code{background}. If \code{NULL} (default), will inherit from the parent \code{layout}.}

\item{active}{A \code{\link[=active]{active()}} object that defines the context settings when
added to a layout.}
}
\value{
A \code{HeatmapLayout} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

The \code{ggoncoplot()} function generates \code{oncoPrint} visualizations that display
genetic alterations in a matrix format. This function is especially useful
for visualizing complex genomic data, such as mutations, copy number
variations, and other genomic alterations in cancer research.
}
\details{
\code{ggoncoplot()} is a wrapper around the \code{\link[=ggheatmap]{ggheatmap()}} function, designed to
simplify the creation of \code{OncoPrint}-style visualizations. The function
automatically processes the input character matrix by splitting the encoded
alterations (delimited by regex \verb{[;:,|]}) into individual genomic events and
unnesting the columns for visualization.

Additionally, a predefined reordering function, adapted from
\url{https://gist.github.com/armish/564a65ab874a770e2c26}, is included to enhance
the organization of the alterations.
}
\examples{
# A simple example from `ComplexHeatmap`
mat <- read.table(textConnection(
    "s1,s2,s3
g1,snv;indel,snv,indel
g2,,snv;indel,snv
g3,snv,,indel;snv"
), row.names = 1, header = TRUE, sep = ",", stringsAsFactors = FALSE)

ggoncoplot(mat, map_width = c(snv = 0.5), map_height = c(indel = 0.9)) +
    # Note that guide legends from `geom_tile` and `geom_bar` are different.
    # Although they appear similar, the internal mechanisms won't collapse
    # the guide legends. Therefore, we remove the guide legends from
    # `geom_tile`.
    guides(fill = "none") +
    anno_top(size = 0.5) +
    ggalign() +
    geom_bar(aes(fill = value), data = function(x) {
        subset(x, !is.na(value))
    }) +
    anno_right(size = 0.5) +
    ggalign() +
    geom_bar(aes(fill = value), orientation = "y", data = function(x) {
        subset(x, !is.na(value))
    }) &
    scale_fill_brewer(palette = "Dark2", na.translate = FALSE)
}
