% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_partial_coplot.R
\name{gg_partial_coplot.rfsrc}
\alias{gg_partial_coplot}
\alias{gg_partial_coplot.rfsrc}
\title{Data structures for stratified partial coplots}
\usage{
gg_partial_coplot.rfsrc(object, xvar, groups, surv_type = c("mort",
  "rel.freq", "surv", "years.lost", "cif", "chf"), time, ...)
}
\arguments{
\item{object}{\code{\link[randomForestSRC]{rfsrc}} object}

\item{xvar}{list of partial plot variables}

\item{groups}{vector of stratification variable.}

\item{surv_type}{for survival random forests,  c("mort", "rel.freq", "surv", 
"years.lost", "cif", "chf")}

\item{time}{vector of time points for survival random forests partial plots.}

\item{...}{extra arguments passed to \code{\link[randomForestSRC]{plot.variable}} function}
}
\value{
\code{gg_partial_coplot} object. An subclass of a 
\code{\link{gg_partial_list}} object
}
\description{
Data structures for stratified partial coplots
}
\examples{
# Load the forest
data(rfsrc_pbc, package="ggRandomForests")

# Create the variable plot.
ggvar <- gg_variable(rfsrc_pbc, time = 1)

# Find intervals with similar number of observations.
copper_cts <-quantile_pts(ggvar$copper, groups = 6, intervals = TRUE)

# Create the conditional groups and add to the gg_variable object
copper_grp <- cut(ggvar$copper, breaks = copper_cts)

\dontrun{
## We would run this, but it's expensive 
partial_coplot_pbc <- gg_partial_coplot(rfsrc_pbc, xvar = "bili", 
                                         groups = copper_grp, 
                                         surv_type = "surv", 
                                         time = 1, 
                                         show.plots = FALSE)
}
## so load the cached set
data(partial_coplot_pbc, package="ggRandomForests")

# Partial coplot
plot(partial_coplot_pbc) #, se = FALSE)
 

}

