% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmxClass.R
\name{pmx_endpoint}
\alias{pmx_endpoint}
\title{Creates pmx endpoint object}
\usage{
pmx_endpoint(code, label = "", unit = "", file.code = code,
  trans = NULL)
}
\arguments{
\item{code}{\code{character} endpoint code : used to filter observations DVID==code.}

\item{label}{\code{character} endpoint label: used to set title and axis labels}

\item{unit}{\code{character} endpoint unit : used to set title and axis labels}

\item{file.code}{\code{character} endpoint file code : used to set predictions and finegrid \cr
files extensions in case using code parameter is not enough.}

\item{trans}{\code{list} Transformation parameter not used yet.}
}
\description{
Creates pmx endpoint object
}
\details{
In case of multiple endpoints, pkpd case for example, we need to pass endpoint to the pmx call.
Internally , ggPMX will filter the observations data set to keep only rows satisfying \code{DVID==code}.
The \code{code} is also used to find the right predictions and or fingrid files.
ggPMX use the configuration file to fine the path of the predictions file
(like the single endpoint case) and then filter the right file using the code parameter. \cr
For example:
\itemize{
\item predictions\{code\}.txt for mlx16
\item predictions\{code\}.txt  and y\{code\}_residual for mlx18
}

For some tricky examples the code parameter is not enough to find the files. In that case the
\code{file.code} parameter is used to distinguish the endpoint files.
}
\examples{
\donttest{
## Use file.code parameter
pk_pd_path <- file.path(system.file(package = "ggPMX"), "testdata","pk_pd")

WORK_DIR <- file.path(pk_pd_path, "RESULTS")

ep <- pmx_endpoint(
  code="4",
  file.code="2"
)

input_file <- file.path(pk_pd_path, "pk_pd.csv")

ctr <- pmx_mlx(
  config = "standing",
  directory = WORK_DIR,
  input = input_file,
  dv = "dv",
  dvid = "dvid",
  cats = "sex",
  conts = "wt",
  endpoint = ep
 )

## using mlxtran 

ep <- pmx_endpoint(
  code="3",
 file.code="1"
)

mlxtran_file <- file.path(pk_pd_path, "pk_pd.mlxtran")
ctr <- pmx_mlxtran(mlxtran_file,endpoint=ep)
}
}
