% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_crs.R
\name{convert_crs}
\alias{convert_crs}
\title{convert_crs, system specific epsg code string formating for CRS.}
\usage{
convert_crs(epsg = 4326)
}
\arguments{
\item{epsg}{EPSG code of the projection (coercible to a character string).}
}
\value{
A character string that can be used as projargs in the CRS (sp) function: either a SRS_string
(e.g. \code{"EPSG:4326"}) or a "+init" PROJ string (e.g. \code{"+init=epsg:4326"}), depending on the libraries and
packages versions used.
}
\description{
Temporary workaround for the specification of projargs in CRS(), required by migration to
GDAL >= 3 and PROJ >= 6.
}
\details{
Test the version of GDAL, PROJ and sp, and return the appropriate format.
}
\examples{
convert_crs()
sp::CRS(projargs = convert_crs())
sp::CRS(projargs = convert_crs(epsg = 27700))
}
\author{
Yves Reecht
}
\keyword{internal}
