% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggInterval_index.r
\name{ggInterval_index}
\alias{ggInterval_index}
\title{Plot the range of each observations}
\usage{
ggInterval_index(data = NULL,mapping = aes(NULL))
}
\arguments{
\item{data}{A ggESDA object. It can also be either RSDA object or
classical data frame,which will be automatically convert to ggESDA
data.}

\item{mapping}{Set of aesthetic mappings created by aes() or aes_().
If specified and inherit. aes = TRUE (the default),
it is combined with the default mapping at the top level of
the plot. You must supply mapping if there is no plot mapping.
It is the same as the mapping of ggplot2.}
}
\value{
Return a ggplot2 object.
}
\description{
Visualize the range of the variables of each observations
by using a kind of margin bar that indicate the minimal and maximal of
observations.
}
\examples{
#the observations show on the y-axis .values on x-axis
ggInterval_index(iris,aes(x=iris$Sepal.Length))

#change above axis
ggInterval_index(mtcars,aes(y=disp,col="red",fill="grey"))

#symbolic data
mydata <- RSDA::facedata
ggInterval_index(mydata,aes(x=3:13,y=AD))

}
