% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggparallel_specific_utils.R
\name{get_optimal_axis_order}
\alias{get_optimal_axis_order}
\title{Optimize Axis Ordering Directly from a Data Frame}
\usage{
get_optimal_axis_order(
  data,
  verbose = TRUE,
  method = "auto",
  metric = c("mutinfo", "crossings", "crossings_fast"),
  return_detailed = FALSE
)
}
\arguments{
\item{data}{A \code{data.frame} or \code{tibble} containing the dataset. Only numeric
columns are considered for edge crossing calculations.}

\item{verbose}{A logical value; if \code{TRUE}, prints progress messages.}

\item{method}{A character string specifying the method. Options are \code{"auto"},
\code{"brute_force"}, or \code{"repetitive_nn_with_2opt"}.}

\item{metric}{which metric should take as the distance between axes to minimise.
mutual information: minimise mutual distance (1- uniminmax of mutinfo similarity matrix calculated by emp)
crossings: minimise the total number of edge crossings (warning: slow to compute for large datasets).
crossings_fast: same as above but calculates crossings on a subset of data (100 rows)}

\item{return_detailed}{A logical; if \code{TRUE}, returns a list with additional
data (e.g., intermediate calculations) for debugging.}
}
\value{
A character vector of axis names in the chosen order, or a list with
additional data if \code{return_detailed = TRUE}.
}
\description{
Computes the number of edge crossings between all numeric columns in \code{data},
converts this information into a distance matrix, and then determines an
optimal ordering of the columns based on the specified method.
}
\keyword{internal}
