% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_effects.R
\name{main_effects}
\alias{main_effects}
\title{Obtain main effect plots in a factorial design}
\usage{
main_effects(
  design,
  response,
  exclude_vars = c(),
  n_columns = 2,
  color_palette = NA,
  alpha = 1,
  direction = 1,
  showplot = TRUE
)
}
\arguments{
\item{design}{Design of experiment (Factorial Design)}

\item{response}{A character string indicating the response of the data}

\item{exclude_vars}{A vector containing variables to exclude}

\item{n_columns}{number of columns for facet grid. Default is 2}

\item{color_palette}{A character string indicating the color map option to use. Eight options are available: "viridis","cividis","magma","inferno","plasma","rocket","mako","turbo"}

\item{alpha}{The alpha transparency, a number in [0,1]}

\item{direction}{Sets the order of colors in the scale. If 1, the default, colors are ordered from darkest to lightest. If -1, the order of colors is reversed}

\item{showplot}{logical indicating to show the main effect plots. If false, a list of tibbles is returned used to obtain the main effects for each factor. Default is TRUE}
}
\value{
Main effects plots, or a list of tibble with calculated main effects for each factors if showplot=FALSE.
}
\description{
Obtain main effect plots in a factorial design
}
\examples{
main_effects(original_epitaxial,response='s2',exclude_vars = c('ybar','lns2'))
main_effects(original_epitaxial,response='ybar',exclude_vars=c('A','s2','lns2'),n_columns=3)
}
