% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3methods.R
\name{plot.gformula_binary_eof}
\alias{plot.gformula_binary_eof}
\title{Plot method for objects of class "gformula_binary_eof"}
\usage{
\method{plot}{gformula_binary_eof}(
  x,
  covnames = NULL,
  ncol = NULL,
  nrow = NULL,
  common.legend = TRUE,
  legend = "bottom",
  xlab = NULL,
  ylab_cov = NULL,
  ...
)
}
\arguments{
\item{x}{Object of class "gformula_binary_eof".}

\item{covnames}{Vector of character strings specifying the names of the time-varying covariates to be plotted. The ordering of covariates given here is used in the plot grid. Time-varying covariates of type \code{"categorical time"} cannot be included. By default, this argument is set equal to the \code{covnames} argument used in \code{\link{gformula_binary_eof}}, where covariates of type \code{"categorical time"} are removed.}

\item{ncol}{Number of columns in the plot grid. By default, two columns are used when there is at least two plots.}

\item{nrow}{Number of rows in the plot grid. By default, a maximum of six rows is used and additional plots are included in subsequent pages.}

\item{common.legend}{Logical scalar indicating whether to include a legend. The default is \code{TRUE}.}

\item{legend}{Character string specifying the legend position. Valid values are \code{"top"}, \code{"bottom"}, \code{"left"}, \code{"right"}, and \code{"none"}. The default is \code{"bottom"}.}

\item{xlab}{Character string for the x axes of all plots. By default, this argument is set to the \code{time_name} argument specified in \code{\link{gformula_binary_eof}}.}

\item{ylab_cov}{Vector of character strings for the y axes of the plots for the covariates. This argument must be the same length as \code{covnames}. The i-th element of this argument corresponds to the plot for the i-th element of \code{covnames}.}

\item{...}{Other arguments, which are passed to \code{\link[ggpubr]{ggarrange}}.}
}
\value{
An object of class "ggarrange". See documentation of \code{\link[ggpubr]{ggarrange}}.
}
\description{
This function generates graphs of the mean simulated vs. observed values at each time point of the
time-varying covariates under the natural course. For categorical covariates,
the observed and simulated probability of each level are plotted at each time point.
}
\examples{
## Estimating the effect of threshold interventions on the mean of a binary
## end of follow-up outcome
\donttest{
id <- 'id_num'
time_name <- 'time'
covnames <- c('cov1', 'cov2', 'treat')
outcome_name <- 'outcome'
histories <- c(lagged, cumavg)
histvars <- list(c('treat', 'cov1', 'cov2'), c('cov1', 'cov2'))
covtypes <- c('binary', 'zero-inflated normal', 'normal')
covparams <- list(covmodels = c(cov1 ~ lag1_treat + lag1_cov1 + lag1_cov2 + cov3 +
                                  time,
                                cov2 ~ lag1_treat + cov1 + lag1_cov1 + lag1_cov2 +
                                  cov3 + time,
                                treat ~ lag1_treat + cumavg_cov1 +
                                  cumavg_cov2 + cov3 + time))
ymodel <- outcome ~  treat + cov1 + cov2 + lag1_cov1 + lag1_cov2 + cov3
intvars <- list('treat', 'treat')
interventions <- list(list(c(static, rep(0, 7))),
                      list(c(threshold, 1, Inf)))
int_descript <- c('Never treat', 'Threshold - lower bound 1')
nsimul <- 10000
ncores <- 2

gform_bin_eof <- gformula_binary_eof(obs_data = binary_eofdata, id = id,
                                     time_name = time_name,
                                     covnames = covnames,
                                     outcome_name = outcome_name,
                                     covtypes = covtypes,
                                     covparams = covparams,
                                     ymodel = ymodel,
                                     intvars = intvars,
                                     interventions = interventions,
                                     int_descript = int_descript,
                                     histories = histories, histvars = histvars,
                                     basecovs = c("cov3"), seed = 1234,
                                     parallel = TRUE, nsamples = 5,
                                     nsimul = nsimul, ncores = ncores)
plot(gform_bin_eof)
}

}
\seealso{
\code{\link{gformula_binary_eof}}
}
