% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tb_burden.R
\name{get_tb_burden}
\alias{get_tb_burden}
\title{Get the WHO TB Burden Data}
\usage{

  get_tb_burden(url = "https://extranet.who.int/tme/generateCSV.asp?ds=estimates",
  download_data = TRUE, save = TRUE, burden_save_name = "TB_burden",
  return = TRUE, verbose = TRUE, use_utils = FALSE)
}
\arguments{
\item{url}{Character string, indicating  the url of the TB burden data.
Default is current url.}

\item{download_data}{Logical, defaults to \code{TRUE}. If not found locally should the data be
downloaded from the specified URL?}

\item{save}{Logical, should the data be saved for reuse during the current R session. Defaults to
\code{TRUE}. If \code{TRUE} then the data is saved to the temporary directory specified by \code{\link[base]{tempdir}}.}

\item{burden_save_name}{Character string, name to save the data under. Defaults to
\code{TB_burden}.}

\item{return}{Logical, should the data be returned as a dataframe.
Defaults to \code{TRUE}.}

\item{verbose}{Logical, defaults to \code{TRUE}. Should additional status and progress messages
be displayed.}

\item{use_utils}{Logical, defaults to \code{FALSE}. Used for testing alternative
data download function. When \code{TRUE} data is downloaded using \code{read.csv}.}
}
\value{
The WHO TB burden data as a tibble.
}
\description{
Get the TB burden data from the WHO, see
\href{http://www.who.int/tb/country/data/download/en/}{here} for details. This function will first attempt
to load the data from the temporary directory (\code{\link[base]{tempdir}}). If that fails, and \code{download_data = TRUE}, it
will instead download the data.
}
\examples{

tb_burden <- get_tb_burden()

head(tb_burden)

}
\seealso{
get_data search_data_dict
}
