% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataexamples.R
\name{dataexamples}
\alias{dataexamples}
\title{Generate Simulated Example Datasets}
\usage{
dataexamples(n = 1000, seed = NULL, Censoring = FALSE)
}
\arguments{
\item{n}{Number of individuals in the dataset.}

\item{seed}{Random seed used for data generation.}

\item{Censoring}{TRUE or FALSE indicator of whether to include a censoring indicator C.
If \code{Censoring=TRUE}, data entries for A, Y, L and U are set to missing after censoring.}
}
\value{
Returns a list of four datasets labeled \code{datagest}, \code{datagestmult},
\code{datagestcat}, and \code{datagestmultcat}, designed to demonstrate the respective
functions.
}
\description{
The code simulates four datasets designed to demonstrate each of the four
g-estimation functions of the package. These are used in the examples for each function
in the user manual. Each dataset comprises of an outcome Y (time-varying or end of study), time-varying exposure A, time-varying confounder L,
a baseline confounder U, and optionally a censoring indicator C over 3 time periods.
}
\examples{
datas<-dataexamples(n=1000,seed=34567,Censoring=FALSE)
data<-datas$datagest
head(data,n=20)
#Multiple outcome data with censoring
datas<-dataexamples(n=100,seed=34567,Censoring=TRUE)
data<-datas$datagestmultcat
head(data,n=20)
}
