% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch.R
\name{git_fetch}
\alias{git_fetch}
\alias{git_remote_ls}
\alias{git_push}
\alias{git_clone}
\alias{git_pull}
\title{Push and pull}
\usage{
git_fetch(
  remote = NULL,
  refspec = NULL,
  password = askpass,
  ssh_key = NULL,
  prune = FALSE,
  verbose = interactive(),
  repo = "."
)

git_remote_ls(
  remote = NULL,
  password = askpass,
  ssh_key = NULL,
  verbose = interactive(),
  repo = "."
)

git_push(
  remote = NULL,
  refspec = NULL,
  set_upstream = NULL,
  password = askpass,
  ssh_key = NULL,
  mirror = FALSE,
  force = FALSE,
  verbose = interactive(),
  repo = "."
)

git_clone(
  url,
  path = NULL,
  branch = NULL,
  password = askpass,
  ssh_key = NULL,
  bare = FALSE,
  mirror = FALSE,
  verbose = interactive()
)

git_pull(remote = NULL, rebase = FALSE, ..., repo = ".")
}
\arguments{
\item{remote}{Optional. Name of a remote listed in \code{\link[=git_remote_list]{git_remote_list()}}. If
unspecified and the current branch is already tracking branch a remote
branch, that remote is honored. Otherwise, defaults to \code{origin}.}

\item{refspec}{string with mapping between remote and local refs. Default
uses the default refspec from the remote, which usually fetches all branches.}

\item{password}{a string or a callback function to get passwords for authentication
or password protected ssh keys. Defaults to \link[askpass:askpass]{askpass} which
checks \code{getOption('askpass')}.}

\item{ssh_key}{path or object containing your ssh private key. By default we
look for keys in \code{ssh-agent} and \link[credentials:ssh_credentials]{credentials::ssh_key_info}.}

\item{prune}{delete tracking branches that no longer exist on the remote, or
are not in the refspec (such as pull requests).}

\item{verbose}{display some progress info while downloading}

\item{repo}{The path to the git repository. If the directory is not a
repository, parent directories are considered (see \link{git_find}). To disable
this search, provide the filepath protected with \code{\link[=I]{I()}}. When using this
parameter, always explicitly call by name (i.e. \verb{repo = }) because future
versions of gert may have additional parameters.}

\item{set_upstream}{change the branch default upstream to \code{remote}.
If \code{NULL}, this will set the branch upstream only if the push was
successful and if the branch does not have an upstream set yet.}

\item{mirror}{use the \code{--mirror} flag}

\item{force}{use the \code{--force} flag}

\item{url}{remote url. Typically starts with \verb{https://github.com/} for public
repositories, and \verb{https://yourname@github.com/} or \verb{git@github.com/} for
private repos. You will be prompted for a password or pat when needed.}

\item{path}{Directory of the Git repository to create.}

\item{branch}{name of branch to check out locally}

\item{bare}{use the \code{--bare} flag}

\item{rebase}{if TRUE we try to rebase instead of merge local changes. This
is not possible in case of conflicts (you will get an error).}

\item{...}{arguments passed to \link{git_fetch}}
}
\description{
Functions to connect with a git server (remote) to fetch or push changes.
The 'credentials' package is used to handle authentication, the
\href{https://docs.ropensci.org/credentials/articles/intro.html}{credentials vignette}
explains the various authentication methods for SSH and HTTPS remotes.
}
\details{
Use \code{\link[=git_fetch]{git_fetch()}} and \code{\link[=git_push]{git_push()}} to sync a local branch with a remote
branch. Here \code{\link[=git_pull]{git_pull()}} is a wrapper for \code{\link[=git_fetch]{git_fetch()}} which then tries to
\link[=git_branch_fast_forward]{fast-forward} the local branch after fetching.
}
\examples{
{# Clone a small repository
git_dir <- file.path(tempdir(), 'antiword')
git_clone('https://github.com/ropensci/antiword', git_dir)

# Change into the repo directory
olddir <- getwd()
setwd(git_dir)

# Show some stuff
git_log()
git_branch_list()
git_remote_list()

# Add a file
write.csv(iris, 'iris.csv')
git_add('iris.csv')

# Commit the change
jerry <- git_signature("Jerry", "jerry@hotmail.com")
git_commit('added the iris file', author = jerry)

# Now in the log:
git_log()

# Cleanup
setwd(olddir)
unlink(git_dir, recursive = TRUE)
}
}
\seealso{
Other git: 
\code{\link{git_archive}},
\code{\link{git_branch}()},
\code{\link{git_commit}()},
\code{\link{git_config}()},
\code{\link{git_diff}()},
\code{\link{git_merge}()},
\code{\link{git_rebase}()},
\code{\link{git_remote}},
\code{\link{git_repo}},
\code{\link{git_signature}()},
\code{\link{git_stash}},
\code{\link{git_tag}}
}
\concept{git}
