% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/branch.R
\name{git_branch}
\alias{git_branch}
\alias{git_branch_list}
\alias{git_branch_checkout}
\alias{git_branch_create}
\alias{git_branch_delete}
\alias{git_branch_fast_forward}
\alias{git_branch_set_upstream}
\alias{git_branch_exists}
\title{Git Branch}
\usage{
git_branch(repo = ".")

git_branch_list(repo = ".")

git_branch_checkout(branch, force = FALSE, repo = ".")

git_branch_create(branch, ref = "HEAD", checkout = TRUE, repo = ".")

git_branch_delete(branch, repo = ".")

git_branch_fast_forward(ref, repo = ".")

git_branch_set_upstream(upstream, branch = git_branch(repo), repo = ".")

git_branch_exists(branch, local = TRUE, repo = ".")
}
\arguments{
\item{repo}{The path to the git repository. If the directory is not a
repository, parent directories are considered (see \link{git_find}). To disable
this search, provide the filepath protected with \code{\link[=I]{I()}}.}

\item{branch}{name of branch to check out}

\item{force}{ignore conflicts and overwrite modified files}

\item{ref}{string with a branch/tag/commit}

\item{checkout}{move HEAD to the newly created branch}

\item{upstream}{remote branch from \link{git_branch_list}, for example \code{"origin/master"}}

\item{local}{set FALSE to check for remote branch names.}
}
\description{
Create, list, and checkout branches.
}
\seealso{
Other git: 
\code{\link{git_archive}},
\code{\link{git_commit}()},
\code{\link{git_config}()},
\code{\link{git_diff}()},
\code{\link{git_fetch}()},
\code{\link{git_merge}()},
\code{\link{git_rebase}()},
\code{\link{git_remote}},
\code{\link{git_repo}},
\code{\link{git_signature}()},
\code{\link{git_stash}},
\code{\link{git_tag}}
}
\concept{git}
