% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redu_leter.R
\name{redu_leter}
\alias{redu_leter}
\title{Article Information Organizer for specific standards formats.}
\usage{
redu_leter(input_date, input_tam, position_artic, total_list)
}
\arguments{
\item{input_date}{is a dataframe with the scientific production database obtained of colection WoS, Scopus and others}

\item{input_tam}{is the length of the dataframe with the main scientifics articles, obtained using package bibliorefer.}

\item{position_artic}{is a parameter that shows the positions of the articles in the main list, obtained using package bibliorefer, chosen to be included in the reference list of a scientific paper. If part of the list is used, the set of articles is presented through a sequence or a concatenated set. If the complete list is used, the complete sequence is created}

\item{total_list}{is the parameter that defines whether all articles from the main list, obtained using package bibliorefer, will be used or not. This parameter contains the logical values TRUE or FALSE. If the full list is used, the value is TRUE. Otherwise, if a part of the list is used, the value is FALSE}
}
\value{
The redu_leter function provides a dataframe with a list of article titles, names of academic journals and names of publishers adapted to specific standards.
}
\description{
The redu_leter function provides a dataframe with a list of article titles, names of academic journals and names of publishers of the main scientific references, adapted to specific standards.The rules of some scientific journals establish that information, in relation to references, must have the first letter capitalized and the rest lowercase. The redu_leter function internally calls the principal_lister function, from the bibliorefer package, to generate the main list of scientific references. Then the article titles, names of academic journals and names of publishers are separated in a dataframe and undergo changes in the format of the letters. The first letter is transformed to the uppercase standard and the rest are transformed to the lowercase standard. The output of the function is a dataframe with titles, magazine names and publisher names in the formatting standard, which meets specific standards.
}
\examples{

# Example 1 - Concatenated position article

# File of database
file_db <- system.file("extdata","example_database.csv", package = "gerefer")
separator <- ","

# Parameters of the function
input_date <- example_database(file_db, separator)
input_tam <- 50
total_list <- FALSE
position_artic <- c(1, 2, 3, 5, 6, 8, 10, 12, 15, 17, 19, 23, 24,
     26, 28, 29, 30, 32, 33, 35, 36, 37, 38, 39, 40, 42, 44, 46, 47, 48)

#Calls the function redu_leter
especific_info <- redu_leter(input_date, input_tam, position_artic, total_list)
especific_info

# Example 2 - Position article in sequence

# File of database
file_db <- system.file("extdata","example_database.csv", package = "gerefer")
separator <- ","

# Parameters of the function
input_date <- example_database(file_db, separator)
input_tam <- 50
total_list <- FALSE
position_artic <- seq(6, 35, 1)

# Call the function redu_leter
especific_info <- redu_leter(input_date, input_tam, position_artic, total_list)
especific_info

# Example 3 - Total list article

# File of database
file_db <- system.file("extdata","example_database.csv", package = "gerefer")
separator <- ","

# Parameters of the function
input_date <- example_database(file_db, separator)
input_tam <- 50
total_list <- TRUE
position_artic <- seq(1, input_tam, 1)

# Call the function redu_leter
especific_info <- redu_leter(input_date, input_tam, position_artic, total_list)
especific_info


}
\references{
1 - Aria, M. & Cuccurullo, C. (2017) bibliometrix: An R-tool for comprehensive science mapping analysis, Journal of Informetrics, 11(4), pp 959-975, Elsevier.
2 - Mukherjee, Debmalya & Lim, Weng Marc & Kumar, Satish & Donthu, Naveen, 2022. "Guidelines for advancing theory and practice through bibliometric research," Journal of Business Research, Elsevier, vol. 148(C), pages 101-115.
}
