% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_gps_to_rayshader.R
\name{add_gps_to_rayshader}
\alias{add_gps_to_rayshader}
\title{Adds a GPS trace to a 'rayshader' scene}
\usage{
add_gps_to_rayshader(raster_input, lat, long, alt, zscale,
  line_width = 1, colour = "red", alpha = 0.8, lightsaber = TRUE,
  clamp_to_ground = FALSE, raise_agl = 0, ground_shadow = FALSE,
  as_line = TRUE, point_size = 20)
}
\arguments{
\item{raster_input}{a raster}

\item{lat}{vector of decimal latitude points}

\item{long}{vector of decimal longitude points}

\item{alt}{vector of altitudes}

\item{zscale}{ratio of raster cells to altitude}

\item{line_width}{line width of the gps trace}

\item{colour}{colour of the gps trace}

\item{alpha}{alpha of the gps trace (has no effect if lightsaber = TRUE)}

\item{lightsaber}{(default = TRUE) gives the GPS trace an inner glow affect}

\item{clamp_to_ground}{(default = FALSE) clamps the gps trace to ground level + raise_agl}

\item{raise_agl}{(default = 0) raises a clamped to ground track by the specified amount. Useful if gps track occasionally disappears into the ground.}

\item{ground_shadow}{(default = FALSE) adds a ground shadow to a flight gps trace}

\item{as_line}{(default = TRUE) Set to FALSE to render single points instead of a trace line (which then ignores line_width & lightsaber)}

\item{point_size}{size of points when as_line = TRUE}
}
\value{
Adds GPS trace to the current 'rayshader' scene
}
\description{
Adds a GPS trace to a 'rayshader' scene
}
\examples{
flight <- example_igc()
add_gps_to_rayshader(example_raster(),
  flight$lat,
  flight$long,
  flight$altitude,
  zscale = raster_zscale(example_raster()))

}
