#' @name NVDI
#' @aliases NVDI
#' @title Normalized Difference Vegetation Index experiment
#'
#' @description Field experiment, realized in CTI (Tecnical Center of Irrigation), in an area of
#' 3 m x 24 m, with 88 observations in a regular grid.
#'
#' @docType data
#'
#' @usage data(soilmoisture)
#'
#' @format An object of class data.frame
#' @details
#' \itemize{
#' \item \bold{x} a vector containing the sample locations(in cm) in the horizontal.
#' \item \bold{y} a vector containing the sample locations(in cm) in the vertical.
#' \item \bold{z} a vector containing the value of normalized difference vegetation index (NDVI).
#' }
#' @keywords datasets
#'
#' @references HARA. A. T., GONÇALVES, A. C. A. Temporal stability of the spatial pattern of water storage in the soil at different
#' spatial scales. (Doctoral thesis). Retrieved from url \url{http://www.pga.uem.br/dissertacao-tese/710}
#'
#'
NULL
