% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSCoverage.R
\docType{class}
\name{GSCoverage}
\alias{GSCoverage}
\title{A GeoServer coverage}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling a GeoServer coverage
}
\description{
This class models a GeoServer coverage. This class is to be
used for manipulating representations of vector data with GeoServer.
}
\details{
Geoserver REST API Resource
}
\examples{
gt <- GSCoverage$new()

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{coverageType}
\keyword{geoserver}
\keyword{resource}
\keyword{rest}
\section{Super classes}{
\code{\link[geosapi:GSRESTResource]{geosapi::GSRESTResource}} -> \code{\link[geosapi:GSResource]{geosapi::GSResource}} -> \code{GSCoverage}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{cqlFilter}}{CQL filter}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GSCoverage-new}{\code{GSCoverage$new()}}
\item \href{#method-GSCoverage-decode}{\code{GSCoverage$decode()}}
\item \href{#method-GSCoverage-setView}{\code{GSCoverage$setView()}}
\item \href{#method-GSCoverage-delView}{\code{GSCoverage$delView()}}
\item \href{#method-GSCoverage-clone}{\code{GSCoverage$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="encode"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-encode'><code>geosapi::GSRESTResource$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="addKeyword"><a href='../../geosapi/html/GSResource.html#method-GSResource-addKeyword'><code>geosapi::GSResource$addKeyword()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="addMetadataLink"><a href='../../geosapi/html/GSResource.html#method-GSResource-addMetadataLink'><code>geosapi::GSResource$addMetadataLink()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="delKeyword"><a href='../../geosapi/html/GSResource.html#method-GSResource-delKeyword'><code>geosapi::GSResource$delKeyword()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="delMetadata"><a href='../../geosapi/html/GSResource.html#method-GSResource-delMetadata'><code>geosapi::GSResource$delMetadata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="deleteMetadataLink"><a href='../../geosapi/html/GSResource.html#method-GSResource-deleteMetadataLink'><code>geosapi::GSResource$deleteMetadataLink()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setAbstract"><a href='../../geosapi/html/GSResource.html#method-GSResource-setAbstract'><code>geosapi::GSResource$setAbstract()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setDescription"><a href='../../geosapi/html/GSResource.html#method-GSResource-setDescription'><code>geosapi::GSResource$setDescription()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setEnabled"><a href='../../geosapi/html/GSResource.html#method-GSResource-setEnabled'><code>geosapi::GSResource$setEnabled()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setKeywords"><a href='../../geosapi/html/GSResource.html#method-GSResource-setKeywords'><code>geosapi::GSResource$setKeywords()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setLatLonBoundingBox"><a href='../../geosapi/html/GSResource.html#method-GSResource-setLatLonBoundingBox'><code>geosapi::GSResource$setLatLonBoundingBox()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setMetadata"><a href='../../geosapi/html/GSResource.html#method-GSResource-setMetadata'><code>geosapi::GSResource$setMetadata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setMetadataDimension"><a href='../../geosapi/html/GSResource.html#method-GSResource-setMetadataDimension'><code>geosapi::GSResource$setMetadataDimension()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setMetadataLinks"><a href='../../geosapi/html/GSResource.html#method-GSResource-setMetadataLinks'><code>geosapi::GSResource$setMetadataLinks()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setName"><a href='../../geosapi/html/GSResource.html#method-GSResource-setName'><code>geosapi::GSResource$setName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setNativeBoundingBox"><a href='../../geosapi/html/GSResource.html#method-GSResource-setNativeBoundingBox'><code>geosapi::GSResource$setNativeBoundingBox()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setNativeCRS"><a href='../../geosapi/html/GSResource.html#method-GSResource-setNativeCRS'><code>geosapi::GSResource$setNativeCRS()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setNativeName"><a href='../../geosapi/html/GSResource.html#method-GSResource-setNativeName'><code>geosapi::GSResource$setNativeName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setProjectionPolicy"><a href='../../geosapi/html/GSResource.html#method-GSResource-setProjectionPolicy'><code>geosapi::GSResource$setProjectionPolicy()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setSrs"><a href='../../geosapi/html/GSResource.html#method-GSResource-setSrs'><code>geosapi::GSResource$setSrs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setTitle"><a href='../../geosapi/html/GSResource.html#method-GSResource-setTitle'><code>geosapi::GSResource$setTitle()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSCoverage-new"></a>}}
\if{latex}{\out{\hypertarget{method-GSCoverage-new}{}}}
\subsection{Method \code{new()}}{
Initializes a \link{GSCoverage} from XML
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSCoverage$new(xml = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link{XMLInternalNode-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSCoverage-decode"></a>}}
\if{latex}{\out{\hypertarget{method-GSCoverage-decode}{}}}
\subsection{Method \code{decode()}}{
Decodes coverage from XML
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSCoverage$decode(xml)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link{XMLInternalNode-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSCoverage-setView"></a>}}
\if{latex}{\out{\hypertarget{method-GSCoverage-setView}{}}}
\subsection{Method \code{setView()}}{
Set view
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSCoverage$setView(cv)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cv}}{cv, object of class \link{GSCoverageView}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if set, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSCoverage-delView"></a>}}
\if{latex}{\out{\hypertarget{method-GSCoverage-delView}{}}}
\subsection{Method \code{delView()}}{
Deletes view
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSCoverage$delView()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSCoverage-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GSCoverage-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSCoverage$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
