% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GSDataStoreManager.R
\docType{class}
\name{GSDataStoreManager}
\alias{GSDataStoreManager}
\title{Geoserver REST API DataStore Manager}
\format{\code{\link{R6Class}} object.}
\usage{
GSDataStoreManager
}
\value{
Object of \code{\link{R6Class}} with methods for managing GeoServer
DataStores (i.e. stores of vector data)
}
\description{
Geoserver REST API DataStore Manager
}
\section{Methods}{

\describe{
 \item{\code{new(url, user, pwd, logger)}}{
   This method is used to instantiate a GSManager with the \code{url} of the
   GeoServer and credentials to authenticate (\code{user}/\code{pwd}). By default,
   the \code{logger} argument will be set to \code{NULL} (no logger). This argument
   accepts two possible values: \code{INFO}: to print only geosapi logs,
   \code{DEBUG}: to print geosapi and CURL logs
 }
 \item{\code{getDataStores(ws)}}{
   Get the list of available dataStores. Returns an object of class \code{list}
   giving items of class \code{\link{GSDataStore}}
 }
 \item{\code{getDataStoreNames(ws)}}{
   Get the list of available dataStore names. Returns an vector of class \code{character}
 }
 \item{\code{getDataStore(ws, ds)}}{
   Get an object of class \code{\link{GSDataStore}} given a workspace and datastore
   names.
 }
 \item{\code{createDataStore(ws, dataStore)}}{
   Creates a new datastore given a workspace and an object of class \code{\link{GSDataStore}}
 }
 \item{\code{updateDataStore(ws, dataStore)}}{
   Updates an existing dataStore given a workspace and an object of class \code{\link{GSDataStore}}
 }
 \item{\code{deleteDataStore(ws, ds, recurse)}}{
   Deletes a datastore given a workspace and an object of class \code{\link{GSDataStore}}.
   By defaut, the option \code{recurse} is set to FALSE, ie datastore layers are not removed.
   To remove all datastore layers, set this option to TRUE.
 }
 \item{\code{getFeatureTypes(ws, ds)}}{
   Get the list of available feature types for given workspace and datastore.
   Returns an object of class \code{list} giving items of class \code{\link{GSFeatureType}}
 }
 \item{\code{getFeatureTypeNames(ws, ds)}}{
   Get the list of available feature type names for given workspace and datastore.
   Returns an vector of class\code{character}
 }
 \item{\code{getFeatureType(ws, ds, ft)}}{
   Get an object of class \code{\link{GSFeatureType}} given a workspace, datastore
   and feature type names.
 }
 \item{\code{createFeatureType(ws, ds, featureType)}}{
   Creates a new featureType given a workspace, datastore names and an object of
   class \code{\link{GSFeatureType}}
 }
 \item{\code{updateFeatureType(ws, ds, FeatureType)}}{
   Updates a new featureType given a workspace, datastore names and an object of
   class \code{\link{GSFeatureType}}
 }
 \item{\code{deleteFeatureType(ws, ds, featureType, recurse)}}{
   Deletes a featureType given a workspace, datastore names, and an object of
   class \code{\link{GSFeatureType}}. By defaut, the option \code{recurse} is
   set to FALSE, ie datastore layers are not removed.
 }
 \item{\code{uploadData(ws, ds, endpoint, extension,
                        configure, update, filename, charset, contentType)}}{
   Uploads data to a target dataStore
 }
 \item{\code{uploadShapefile(ws, ds, endpoint,
                             configure, update, filename, charset)}}{
   Uploads a zipped ESRIshapefile to a target dataStore
 }
 \item{\code{uploadProperties(ws, ds, endpoint,
                              configure, update, filename, charset)}}{
   Uploads a properties file to a target dataStore
 }
 \item{\code{uploadH2(ws, ds, endpoint,
                      configure, update, filename, charset)}}{
   Uploads a H2 database to a target dataStore
 }
 \item{\code{uploadSpatialite(ws, ds, endpoint,
                              configure, update, filename, charset)}}{
   Uploads a Spatialite database to a target dataStore
 }
 \item{\code{uploadAppschema(ws, ds, endpoint,
                              configure, update, filename, charset)}}{
   Uploads a appschema file to a target dataStore
 }
}
}
\examples{
\dontrun{
   GSDataStoreManager$new("http://localhost:8080/geoserver", "admin", "geoserver")
 }
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{DataStore}
\keyword{api}
\keyword{geoserver}
\keyword{rest}

