% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geos-unary-geometry.R
\name{geos_geometry_n}
\alias{geos_geometry_n}
\alias{geos_ring_n}
\title{Access child geometries}
\usage{
geos_geometry_n(geom, n)

geos_ring_n(geom, n)
}
\arguments{
\item{geom}{A \link[=as_geos_geometry]{GEOS geometry vector}}

\item{n}{The (one-based) index of the child geometry}
}
\value{
A \link[=as_geos_geometry]{GEOS geometry vector} along the recycled
length of \code{geom} and \code{i}.
}
\description{
Access child geometries
}
\examples{
multipoint <- "MULTIPOINT (0 0, 1 1, 2 2)"
geos_geometry_n(multipoint, seq_len(geos_num_geometries(multipoint)))

poly <- "POLYGON ((0 0, 0 1, 1 0, 0 0), (0.1 0.1, 0.1 0.2, 0.2 0.1, 0.1 0.1))"
geos_ring_n(poly, seq_len(geos_num_rings(poly)))

}
