% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/digit.fixed.r
\name{digit.fixed}
\alias{digit.fixed}
\title{Digitize 3D landmarks on mesh3d object}
\usage{
digit.fixed(spec, fixed, index = FALSE, ptsize = 1, center = TRUE)
}
\arguments{
\item{spec}{An object of class shape3d/mesh3d, or matrix of 3D vertex coordinates}

\item{fixed}{The number of landmarks to be digitized (fixed, and curve sliders if desired)}

\item{index}{Whether selected landmark addresses should be returned (internal use only)}

\item{ptsize}{Size of mesh points (vertices), e.g. 0.1 for dense meshes, 3 for sparse meshes}

\item{center}{Should the object 'spec' be centered prior to digitizing?}
}
\value{
Function returns (if assigned to an object) and writes to the working directory an NTS
 file, containing the landmark coordinates. The file name corresponds to the name of the specimen.
If index=FALSE function returns to the console an n x 3 matrix containing the x,y,z coordinates of the digitized landmarks.  
If index=TRUE, function returns a list:
 \item{selected}{a matrix containing the x,y,z coordinates of the digitized landmarks} 
 \item{fix}{a matrix of addresses for landmarks that are "fixed" (for internal use)}
}
\description{
An interactive function to digitize three-dimensional (3D) landmarks.
Input for the function is either a matrix of vertex coordinates defining a 3D surface object
or a mesh3d object as obtained from \code{\link{read.ply}}.
}
\details{
Function for digitizing fixed three-dimensional landmarks. The user can later designate some 
as curve sliding semilandmarks, using the function \code{\link{define.sliders}} or through
a semilandmark definition matrix. 

To digitize 3D surface sliding semilandmarks the function \code{\link{digitsurface}} should be used instead.

For details on the full procedure for digitizing fixed 3D landmarks and surface
sliding semilandmarks, see the relevant vignette by running \code{vignette("geomorph.digitize3D")}.

 NOTE: The function centers the mesh before digitizing by default (center = TRUE). If one chooses not to center,
 specimen may be difficult to manipulate in rgl window.

\subsection{Digitizing}{ 
Digitizing is interactive. Once a point is selected, the user is asked if the system should keep or discard the 
selection (y/n). If "y", the user is asked to continue to select the next landmark. If "n" the removes the last chosen
landmark, and the user is asked to select it again. This can be repeated until the user is comfortable with the 
landmark chosen. 

To digitize with a standard 3-button mouse (PC):
\enumerate{
 \item the RIGHT mouse button (primary) to select points to be digitized,
 \item the LEFT mouse button (secondary) is used to rotate mesh, 
 \item the mouse SCROLLER (third/middle) is used to zoom in and out.
}
NOTE: Digitizing functions on MACINTOSH computers using a standard 3-button mice works as specified. Macs using platform 
specific single button mice, XQuartz must be configured: go to Preferences > Input > tick "Emulate three button mouse":
\enumerate{
 \item press button to rotate 3D mesh,
 \item press button while pressing COMMAND key to select vertex to be used as a landmark,
 \item press button while pressing OPTION key to adjust mesh perspective.
 \item the mouse SCROLLER or trackpad two finger scroll is used to zoom in an out.
 }

NOTE: there is no pan (translate) functionality in rgl library for all platforms at this time.
}
}
\seealso{
\code{\link{read.ply}}

\code{\link[rgl]{rgl-package}} (used in 3D plotting)
}
\author{
Erik Otarola-Castillo & Emma Sherratt
}
\keyword{digitizing}
