% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFeatures.R
\name{getFeatures}
\alias{getFeatures}
\alias{getFeatures,ANY-method}
\alias{getFeatures,geom-method}
\alias{getFeatures,Spatial-method}
\alias{getFeatures,sf-method}
\alias{getFeatures,Raster-method}
\alias{getFeatures,matrix-method}
\title{Get the table of feature attributes}
\usage{
\S4method{getFeatures}{ANY}(x)

\S4method{getFeatures}{geom}(x)

\S4method{getFeatures}{Spatial}(x)

\S4method{getFeatures}{sf}(x)

\S4method{getFeatures}{Raster}(x)

\S4method{getFeatures}{matrix}(x)
}
\arguments{
\item{x}{the object from which to derive the attribute table.}
}
\value{
A tibble (or a list of tibbles per layer) of the feature attributes
  of \code{x}.
}
\description{
Get tabular information of the attributes of features.
}
\details{
This table contains at least the column 'fid'. In case \code{x} has
  any typ other than 'grid', it contains also the column 'gid' and in case it
  has type 'grid', it also contains the column 'values'.
}
\examples{
getFeatures(x = gtGeoms$polygon)

getFeatures(x = gtRasters)

}
\seealso{
Other getters: 
\code{\link{getCRS}()},
\code{\link{getCols}()},
\code{\link{getExtent}()},
\code{\link{getGroups}()},
\code{\link{getHistory}()},
\code{\link{getLayers}()},
\code{\link{getNames}()},
\code{\link{getPoints}()},
\code{\link{getRes}()},
\code{\link{getRows}()},
\code{\link{getType}()},
\code{\link{getWindow}()}
}
\concept{getters}
