% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRes.R
\name{getRes}
\alias{getRes}
\alias{getRes,ANY-method}
\alias{getRes,geom-method}
\alias{getRes,Raster-method}
\alias{getRes,matrix-method}
\title{Get the spatial resolution of a spatial object.}
\usage{
\S4method{getRes}{ANY}(x)

\S4method{getRes}{geom}(x, precision = getOption("digits"))

\S4method{getRes}{Raster}(x, precision = getOption("digits"))

\S4method{getRes}{matrix}(x)
}
\arguments{
\item{x}{the object from which to derive the resolution.}

\item{precision}{the number of digits to which to round the values.}
}
\value{
The resolution of \code{x} in x and y dimension.
}
\description{
Get the spatial resolution of a spatial object.
}
\seealso{
Other getters: 
\code{\link{getCRS}()},
\code{\link{getExtent}()},
\code{\link{getFeatures}()},
\code{\link{getGroups}()},
\code{\link{getHistory}()},
\code{\link{getLayer}()},
\code{\link{getName}()},
\code{\link{getPoints}()},
\code{\link{getType}()},
\code{\link{getWindow}()}
}
\concept{getters}
