% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setTable.R
\docType{methods}
\name{setTable}
\alias{setTable}
\alias{setTable,ANY-method}
\alias{setTable,geom-method}
\alias{setTable,Spatial-method}
\alias{setTable,sf-method}
\alias{setTable,sfc-method}
\alias{setTable,ppp-method}
\alias{setTable,RasterLayer-method}
\title{Set the attribute table(s) of a spatial object.}
\usage{
\S4method{setTable}{ANY}(x)

\S4method{setTable}{geom}(x, table = NULL, slot = "feature")

\S4method{setTable}{Spatial}(x, table = NULL)

\S4method{setTable}{sf}(x, table = NULL)

\S4method{setTable}{sfc}(x, table = NULL)

\S4method{setTable}{ppp}(x, table = NULL)

\S4method{setTable}{RasterLayer}(x, table = NULL)
}
\arguments{
\item{x}{the object to which to assign an attribute table.}

\item{table}{[\code{data.frame(.)}]\cr the attribute table.}

\item{slot}{[\code{character(1)}]\cr the slot (of \code{geom}) for which to
set the attribute table, either \code{"point"}, \code{"feature"} or
\code{"group"}.}
}
\value{
The object \code{x} with an updated attribute table.
}
\description{
Set the attribute table(s) of a spatial object.
}
\details{
If \code{table} does not have columns in common with \code{x}, the
  new columns are simply bound to the original attribute table (if possible).
  If there are common columns, they are joined.
}
\examples{
# set table of a geom
# individual attributes per point/line/polygon feature
getTable(gtGeoms$point)
newAttr <- setTable(x = gtGeoms$point,
                    slot = "point",
                    table = data.frame(attr = letters[c(1:12)]))
getTable(x = newAttr, slot = "point")

newAttr2 <- setTable(x = newAttr,
                     slot = "feature",
                     table = data.frame(gid = c(1:3), attr = letters[1:3]))
getTable(x = newAttr2, slot = "feature")
newAttr2

# set table of an Spatial object
spObj <- gtSP$SpatialPolygonsDataFrame

# ... with common columns
myAttributes <- data.frame(a = c(2, 1), attr = letters[1:2])
setTable(x = spObj, table = myAttributes)

# ... without common columns
setTable(x = spObj, table = myAttributes[2])

# set table of an sf
sfObj <- gtSF$polygon

# ... with common columns
myAttributes <- data.frame(a = c(2, 1), attr = letters[1:2])
setTable(x = sfObj, table = myAttributes)

# ... without common columns
setTable(x = sfObj, table = myAttributes[2])

# set table to an sfc (no join possible) and transform it to sf thereby
sfcObj = gtSF$polygon$geometry
setTable(x = sfcObj, table = myAttributes)

table <- data.frame(attr = LETTERS[1:15],
                    colour = topo.colors(15))
setTable(gtPPP, table = table)
}
\seealso{
Other setters: \code{\link{setCRS}},
  \code{\link{setHistory}}, \code{\link{setWindow}}
}
\concept{setters}
