% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOLocale.R
\docType{class}
\name{ISOLocale}
\alias{ISOLocale}
\title{ISOLocale}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO Locale
}
\description{
ISOLocale
}
\section{Fields}{

\describe{
\item{\code{languageCode}}{[\code{\link{ISOLanguage}}|\code{\link{character}}] language code}

\item{\code{country}}{[\code{\link{ISOCountry}}|\code{\link{character}}] country code}

\item{\code{characterEncoding}}{[\code{\link{ISOCharacterSet}}|\code{\link{character}}] character encoding}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml, code, country, encoding)}}{
   This method is used to instantiate an ISOLocale
 }
 \item{\code{setId(id)}}{
   Set the locale Id, to bind to \code{ISOFreeText} elements to identify a locale text.
 }
 \item{\code{setLanguage(language)}}{
   Set the language, object of class "character" (language code), or object of
   class \code{\link{ISOLanguage}}.
 }
 \item{\code{setCountry(country)}}{
   Set the country, object of class "character" (country code), or object of class
   \code{\link{ISOCountry}}.
 }
 \item{\code{setCharacterSet(charset)}}{
   Set the character encoding, object of class "character" (encoding code), or object
   of class \code{\link{ISOCharacterSet}}.
 }
}
}

\examples{
  loc <- ISOLocale$new()
  loc$setId("eng")
  loc$setLanguage("eng")
  loc$setCountry("UK")
  loc$setCharacterSet("utf8")
  
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{locale}
