% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/center.R
\name{st_circle_center}
\alias{st_circle_center}
\title{Get the centroid of the maximum inscribed circle}
\usage{
st_circle_center(shp, tolerance = 0.01, epsg = 3857)
}
\arguments{
\item{shp}{An sf dataframe}

\item{tolerance}{positive numeric tolerance to simplify by. Default is 0.01.}

\item{epsg}{numeric EPSG code to planarize to. Default is 3857.}
}
\value{
An sf dataframe where geometry is the circle center of each shape in shp
}
\description{
Returns the centroid of the largest inscribed circle for each shape
}
\examples{
data(towns)
st_circle_center(towns)

}
\concept{center}
