% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cancel-geojob.R
\docType{methods}
\name{cancel}
\alias{cancel}
\alias{cancel,geojob-method}
\alias{cancel,missing-method}
\title{cancel a geo-web processing request}
\usage{
cancel(.Object)

\S4method{cancel}{geojob}(.Object)

\S4method{cancel}{missing}(.Object)
}
\arguments{
\item{.Object}{a \linkS4class{geojob} object with an active geo-web processing request.}
}
\value{
A \linkS4class{geojob} object with no active job
}
\description{
Cancel process for \code{geojob}
}
\details{
cancel is a method for cancelling a geo-web processing request.
}
\examples{
wd <- webdata('prism')
wg <- webgeom('state::New Hampshire')
wp <- webprocess()

if(!is.null(wp)) {
 gj <- geojob()
 xml(gj) <- XML(wg, wd, wp)
 url(gj) <- url(wp)
}
\dontrun{
gj <- start(gj)
gj <- cancel(gj)
}
}
\seealso{
\code{check}, \code{start}
}
\keyword{methods}
