% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geobuf.R
\name{geobuf}
\alias{geobuf}
\alias{from_geobuf}
\alias{to_geobuf}
\title{Geobuf serialization}
\usage{
from_geobuf(x, pretty = FALSE)

to_geobuf(x, file = NULL, decimals = 6)
}
\arguments{
\item{x}{(character) a file or raw object for \code{from_geobuf}, and
json string for \code{to_geobuf}}

\item{pretty}{(logical) pretty print JSON. Default: \code{FALSE}}

\item{file}{(character) file to write protobuf to. if NULL, geobuf
raw binary returned}

\item{decimals}{(integer) how many decimals (digits behind the dot) to
store for numbers}
}
\value{
for \code{from_geobuf} JSON as a character string, and for
\code{to_geobuf} raw or file written to disk
}
\description{
Geobuf serialization
}
\details{
\code{from_geobuf} uses \code{protolite::geobuf2json()},
while \code{to_geobuf} uses \code{protolite::json2geobuf()}

Note that \pkg{protolite} expects either a \strong{Feature},
\strong{FeatureCollection}, or \strong{Geometry} class geojson
object, Thus, for \code{to_geobuf} we check the geojson class, and
convert to a \strong{Feature} if the class is something other than
the acceptable set.
}
\examples{
file <- system.file("examples/test.pb", package = "geojson")
(json <- from_geobuf(file))
from_geobuf(file, pretty = TRUE)
pb <- to_geobuf(json)
f <- tempfile(fileext = ".pb")
to_geobuf(json, f)
from_geobuf(f)

object.size(json)
object.size(pb)
file.info(file)$size
file.info(f)$size

file <- system.file("examples/featurecollection1.geojson",
  package = "geojson")
json <- paste0(readLines(file), collapse = "")
to_geobuf(json)

# other geojson class objects
x <- '{ "type": "Polygon",
"coordinates": [
  [ [100.0, 0.0], [101.0, 0.0], [101.0, 1.0], [100.0, 1.0], [100.0, 0.0] ]
  ]
}'
(y <- polygon(x))
to_geobuf(y)

x <- '{"type": "MultiPoint", "coordinates": [ [100.0, 0.0], [101.0, 1.0] ] }'
(y <- multipoint(x))
to_geobuf(y)
}
\references{
Geobuf is a compact binary encoding for geographic data
using protocol buffers https://github.com/mapbox/geobuf
}
